/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.health.utils;

import com.kumuluz.ee.configuration.utils.ConfigurationUtil;
import com.kumuluz.ee.health.HealthRegistry;
import com.kumuluz.ee.health.checks.DataSourceHealthCheck;
import com.kumuluz.ee.health.checks.DiskSpaceHealthCheck;
import com.kumuluz.ee.health.checks.ElasticSearchHealthCheck;
import com.kumuluz.ee.health.checks.EtcdHealthCheck;
import com.kumuluz.ee.health.checks.HttpHealthCheck;
import com.kumuluz.ee.health.checks.MongoHealthCheck;
import com.kumuluz.ee.health.checks.RabbitHealthCheck;
import com.kumuluz.ee.health.checks.RedisHealthCheck;
import java.lang.annotation.Annotation;
import java.sql.DriverManager;
import java.util.Set;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.util.AnnotationLiteral;
import org.eclipse.microprofile.health.Health;
import org.eclipse.microprofile.health.HealthCheck;

public class HealthCheckInitializationExtension
implements Extension {
    private static final Logger LOG = Logger.getLogger(HealthCheckInitializationExtension.class.getName());

    public <T> void registerHealthChecks(@Observes @Initialized(value=ApplicationScoped.class) Object init, BeanManager beanManager) {
        ConfigurationUtil configurationUtil = ConfigurationUtil.getInstance();
        HealthRegistry healthCheckRegistry = HealthRegistry.getInstance();
        if (configurationUtil.get("kumuluzee.health.checks.data-source-health-check").isPresent()) {
            if (!DriverManager.getDrivers().hasMoreElements()) {
                LOG.severe("No database driver library appears to be provided.");
            }
            healthCheckRegistry.register(DataSourceHealthCheck.class.getSimpleName(), new DataSourceHealthCheck());
        }
        if (configurationUtil.get("kumuluzee.health.checks.disk-space-health-check").isPresent()) {
            healthCheckRegistry.register(DiskSpaceHealthCheck.class.getSimpleName(), new DiskSpaceHealthCheck());
        }
        if (configurationUtil.get("kumuluzee.health.checks.elastic-search-health-check").isPresent()) {
            healthCheckRegistry.register(ElasticSearchHealthCheck.class.getSimpleName(), new ElasticSearchHealthCheck());
        }
        if (configurationUtil.get("kumuluzee.health.checks.etcd-health-check").isPresent()) {
            healthCheckRegistry.register(EtcdHealthCheck.class.getSimpleName(), new EtcdHealthCheck());
        }
        if (configurationUtil.get("kumuluzee.health.checks.http-health-check").isPresent()) {
            healthCheckRegistry.register(HttpHealthCheck.class.getSimpleName(), new HttpHealthCheck());
        }
        if (configurationUtil.get("kumuluzee.health.checks.mongo-health-check").isPresent()) {
            try {
                Class.forName("com.mongodb.MongoClient");
            }
            catch (ClassNotFoundException e) {
                LOG.severe("The required mongo-java-driver library appears to be missing.");
            }
            healthCheckRegistry.register(MongoHealthCheck.class.getSimpleName(), new MongoHealthCheck());
        }
        if (configurationUtil.get("kumuluzee.health.checks.rabbit-health-check").isPresent()) {
            try {
                Class.forName("com.rabbitmq.client.Connection");
            }
            catch (ClassNotFoundException e) {
                LOG.severe("The required amqp-client library appears to be missing.");
            }
            healthCheckRegistry.register(RabbitHealthCheck.class.getSimpleName(), new RabbitHealthCheck());
        }
        if (configurationUtil.get("kumuluzee.health.checks.redis-health-check").isPresent()) {
            try {
                Class.forName("redis.clients.jedis.JedisPool");
            }
            catch (ClassNotFoundException e) {
                LOG.severe("The required jedis library appears to be missing.");
            }
            healthCheckRegistry.register(RedisHealthCheck.class.getSimpleName(), new RedisHealthCheck());
        }
        Set beans = beanManager.getBeans(HealthCheck.class, new Annotation[]{new AnnotationLiteral<Health>(){}});
        for (Bean bean : beans) {
            HealthCheck healthCheckBean = (HealthCheck)beanManager.getReference(bean, HealthCheck.class, beanManager.createCreationalContext((Contextual)bean));
            HealthRegistry.getInstance().register(bean.getBeanClass().getSimpleName(), healthCheckBean);
        }
    }
}

