/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.health;

import com.kumuluz.ee.configuration.utils.ConfigurationUtil;
import com.kumuluz.ee.health.HealthServlet;
import com.kumuluz.ee.health.logs.HealthCheckLogger;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Observes;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;

@ApplicationScoped
public class HealthInitiator {
    private static final Logger LOG = Logger.getLogger(HealthInitiator.class.getName());
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    private void initialize(@Observes @Initialized(value=ApplicationScoped.class) Object init) {
        LOG.info("Initializing Health extension");
        ConfigurationUtil configurationUtil = ConfigurationUtil.getInstance();
        String servletMapping = configurationUtil.get("kumuluzee.health.servlet.mapping").orElse("/health");
        LOG.info("Registering health servlet on " + servletMapping);
        ServletRegistration.Dynamic dynamicRegistration = ((ServletContext)init).addServlet("health", (Servlet)new HealthServlet());
        dynamicRegistration.addMapping(new String[]{servletMapping});
        if (configurationUtil.getBoolean("kumuluzee.health.logs.enabled").orElse(true).booleanValue()) {
            int period = configurationUtil.getInteger("kumuluzee.health.logs.period-s").orElse(60);
            String level = configurationUtil.get("kumuluzee.health.logs.level").orElse("FINE");
            LOG.log(Level.INFO, "Starting health logger to log health check results every {0} s", period);
            HealthCheckLogger logger = new HealthCheckLogger(level);
            this.scheduler.scheduleWithFixedDelay(logger, period, period, TimeUnit.SECONDS);
        }
    }
}

