/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.health.checks;

import com.kumuluz.ee.configuration.utils.ConfigurationUtil;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;

public class DataSourceHealthCheck
implements HealthCheck {
    private static final Logger LOG = Logger.getLogger(DataSourceHealthCheck.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HealthCheckResponse call() {
        Connection connection = null;
        try {
            connection = this.getConnection();
            HealthCheckResponse healthCheckResponse = HealthCheckResponse.named((String)DataSourceHealthCheck.class.getSimpleName()).up().build();
            return healthCheckResponse;
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "An exception occurred when trying to establish connection to data source.", exception);
            HealthCheckResponse healthCheckResponse = HealthCheckResponse.named((String)DataSourceHealthCheck.class.getSimpleName()).down().build();
            return healthCheckResponse;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException exception) {
                    LOG.log(Level.SEVERE, "An exception occurred when trying to close connection to data source.", exception);
                }
            }
        }
    }

    private Connection getConnection() throws SQLException {
        ConfigurationUtil configurationUtil = ConfigurationUtil.getInstance();
        Optional jndiName = configurationUtil.get("kumuluzee.health.checks.data-source-health-check.jndi-name");
        Optional dsSizeOpt = configurationUtil.getListSize("kumuluzee.datasources");
        String connectionUrl = null;
        String username = null;
        String password = null;
        if (jndiName.isPresent() && dsSizeOpt.isPresent()) {
            for (int i = 0; i < (Integer)dsSizeOpt.get(); ++i) {
                String prefix = "kumuluzee.datasources[" + i + "]";
                Optional dsJndiName = configurationUtil.get(prefix + ".jndi-name");
                if (!dsJndiName.isPresent() || !((String)dsJndiName.get()).equals(jndiName.get())) continue;
                connectionUrl = configurationUtil.get(prefix + ".connection-url").orElse(null);
                username = configurationUtil.get(prefix + ".username").orElse(null);
                password = configurationUtil.get(prefix + ".password").orElse(null);
                break;
            }
        } else {
            connectionUrl = configurationUtil.get("kumuluzee.health.checks.data-source-health-check.connection-url").orElse(null);
            username = configurationUtil.get("kumuluzee.health.checks.data-source-health-check.username").orElse(null);
            password = configurationUtil.get("kumuluzee.health.checks.data-source-health-check.password").orElse(null);
        }
        return username != null && password != null ? DriverManager.getConnection(connectionUrl, username, password) : DriverManager.getConnection(connectionUrl);
    }
}

