/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.health.checks;

import com.kumuluz.ee.configuration.utils.ConfigurationUtil;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import java.util.logging.Logger;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;

public class MongoHealthCheck
implements HealthCheck {
    private static final Logger LOG = Logger.getLogger(MongoHealthCheck.class.getName());
    private static final String DEFAULT_MONGO_URL = "mongodb://localhost:27017/local?serverSelectionTimeoutMS=2000";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HealthCheckResponse call() {
        String connectionUrl = ConfigurationUtil.getInstance().get("kumuluzee.health.checks.mongo-health-check.connection-url").orElse(DEFAULT_MONGO_URL);
        try (MongoClient mongoClient = null;){
            MongoClientURI mongoClientURI = new MongoClientURI(connectionUrl);
            mongoClient = new MongoClient(mongoClientURI);
            if (this.databaseExist(mongoClient, mongoClientURI.getDatabase()).booleanValue()) {
                HealthCheckResponse healthCheckResponse = HealthCheckResponse.named((String)MongoHealthCheck.class.getSimpleName()).up().build();
                return healthCheckResponse;
            }
            LOG.severe("Mongo database not found.");
            HealthCheckResponse healthCheckResponse = HealthCheckResponse.named((String)MongoHealthCheck.class.getSimpleName()).down().build();
            return healthCheckResponse;
        }
    }

    private Boolean databaseExist(MongoClient mongoClient, String databaseName) {
        if (mongoClient != null && databaseName != null) {
            for (String s : mongoClient.listDatabaseNames()) {
                if (!s.equals(databaseName)) continue;
                return true;
            }
        }
        return false;
    }
}

