/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.health.checks;

import com.kumuluz.ee.configuration.utils.ConfigurationUtil;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;

public class RabbitHealthCheck
implements HealthCheck {
    private static final Logger LOG = Logger.getLogger(RabbitHealthCheck.class.getName());
    private static final String DEFAULT_RABBIT_URL = "amqp://guest:guest@localhost:5672?connection_timeout=2000";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HealthCheckResponse call() {
        String connectionUrl = ConfigurationUtil.getInstance().get("kumuluzee.health.checks.rabbit-health-check.connection-url").orElse(DEFAULT_RABBIT_URL);
        Connection connection = null;
        try {
            ConnectionFactory factory = new ConnectionFactory();
            factory.setUri(connectionUrl);
            connection = factory.newConnection();
            HealthCheckResponse healthCheckResponse = HealthCheckResponse.named((String)RabbitHealthCheck.class.getSimpleName()).up().build();
            return healthCheckResponse;
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "An exception occurred when trying to establish connection to RabbitMQ.", exception);
            HealthCheckResponse healthCheckResponse = HealthCheckResponse.named((String)RabbitHealthCheck.class.getSimpleName()).down().build();
            return healthCheckResponse;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    LOG.log(Level.SEVERE, "An exception occurred when trying to close connection to RabbitMQ.", exception);
                }
            }
        }
    }
}

