/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.health.logs;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.kumuluz.ee.health.HealthRegistry;
import com.kumuluz.ee.health.models.HealthResponse;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.health.HealthCheckResponse;

public class HealthCheckLogger
implements Runnable {
    private static final Logger LOG = Logger.getLogger(HealthCheckLogger.class.getName());
    private static Level LEVEL;
    private ObjectMapper mapper = new ObjectMapper().registerModule((Module)new Jdk8Module());

    public HealthCheckLogger(String level) {
        LEVEL = Level.parse(level.toUpperCase());
    }

    @Override
    public void run() {
        try {
            List<HealthCheckResponse> results = HealthRegistry.getInstance().getResults();
            HealthResponse healthResponse = new HealthResponse();
            healthResponse.setChecks(results);
            healthResponse.setOutcome(results.stream().anyMatch(result -> result.getState().equals((Object)HealthCheckResponse.State.DOWN)) ? HealthCheckResponse.State.DOWN : HealthCheckResponse.State.UP);
            LOG.log(LEVEL, this.mapper.writer().writeValueAsString((Object)healthResponse));
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "An exception occurred when trying to evaluate and log health response.", exception);
        }
    }
}

