/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.health;

import com.kumuluz.ee.common.Extension;
import com.kumuluz.ee.common.KumuluzServer;
import com.kumuluz.ee.common.ServletServer;
import com.kumuluz.ee.common.config.EeConfig;
import com.kumuluz.ee.common.dependencies.EeComponentDependencies;
import com.kumuluz.ee.common.dependencies.EeComponentDependency;
import com.kumuluz.ee.common.dependencies.EeComponentType;
import com.kumuluz.ee.common.dependencies.EeExtensionDef;
import com.kumuluz.ee.common.wrapper.KumuluzServerWrapper;
import com.kumuluz.ee.configuration.utils.ConfigurationUtil;
import com.kumuluz.ee.health.HealthServlet;
import com.kumuluz.ee.health.enums.HealthCheckType;
import com.kumuluz.ee.health.logs.HealthCheckLogger;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

@EeExtensionDef(name="Health", group="health")
@EeComponentDependencies(value={@EeComponentDependency(value=EeComponentType.CDI), @EeComponentDependency(value=EeComponentType.JAX_RS)})
public class HealthExtension
implements Extension {
    private static final Logger LOG = Logger.getLogger(HealthExtension.class.getName());
    private ScheduledExecutorService scheduler;

    public void load() {
    }

    public void init(KumuluzServerWrapper kumuluzServerWrapper, EeConfig eeConfig) {
        LOG.info("Initializing Health extension");
        KumuluzServer server = kumuluzServerWrapper.getServer();
        if (!(server instanceof ServletServer)) {
            LOG.warning("Server is not instance of ServletServer. Health servlet will not be initialized.");
            return;
        }
        ConfigurationUtil configurationUtil = ConfigurationUtil.getInstance();
        String servletMapping = configurationUtil.get("kumuluzee.health.servlet.mapping").orElse("/health/*");
        if (!servletMapping.endsWith("/*")) {
            servletMapping = servletMapping.endsWith("/") ? servletMapping + "*" : servletMapping + "/*";
        }
        LOG.info("Registering health servlet on " + servletMapping);
        ((ServletServer)server).registerServlet(HealthServlet.class, servletMapping, Collections.singletonMap("com.kumuluz.ee.health.servletMapping", servletMapping.substring(0, servletMapping.length() - 2)));
        if (configurationUtil.getBoolean("kumuluzee.health.logs.enabled").orElse(true).booleanValue()) {
            int period = configurationUtil.getInteger("kumuluzee.health.logs.period-s").orElse(60);
            String level = configurationUtil.get("kumuluzee.health.logs.level").orElse("FINE");
            String type = configurationUtil.get("kumuluzee.health.logs.type").orElse("both");
            this.scheduler = Executors.newScheduledThreadPool(1);
            LOG.log(Level.INFO, "Starting health logger to log health check results every {0} s", period);
            HealthCheckLogger logger = new HealthCheckLogger(level, HealthCheckType.parse(type));
            this.scheduler.scheduleWithFixedDelay(logger, period, period, TimeUnit.SECONDS);
        }
    }

    public boolean isEnabled() {
        Optional enabled = ConfigurationUtil.getInstance().getBoolean("kumuluzee.health.enabled");
        return enabled.orElse(true);
    }
}

