/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.health;

import com.kumuluz.ee.health.enums.HealthCheckType;
import com.kumuluz.ee.health.utils.HealthCheckWrapper;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;

public class HealthRegistry {
    private static HealthRegistry instance;
    private ConcurrentMap<String, HealthCheckWrapper> healthChecks = new ConcurrentHashMap<String, HealthCheckWrapper>();

    private HealthRegistry() {
    }

    public static HealthRegistry getInstance() {
        if (instance == null) {
            instance = new HealthRegistry();
        }
        return instance;
    }

    public void register(String healthCheckName, HealthCheck healthCheck, HealthCheckType type) {
        HealthCheckWrapper wrapper = new HealthCheckWrapper(type, healthCheck);
        this.healthChecks.compute(healthCheckName, (k, v) -> v == null ? wrapper : this.mergeWrappers((HealthCheckWrapper)v, wrapper));
    }

    private HealthCheckWrapper mergeWrappers(HealthCheckWrapper existing, HealthCheckWrapper created) {
        if (existing.getType().equals((Object)created.getType())) {
            return created;
        }
        return new HealthCheckWrapper(HealthCheckType.BOTH, created.getHealthCheck());
    }

    public void unregister(String healthCheckName) {
        this.healthChecks.remove(healthCheckName);
    }

    public List<HealthCheckResponse> getResults(HealthCheckType type) {
        return this.healthChecks.values().parallelStream().filter(hcw -> type.equals((Object)HealthCheckType.BOTH) || type.equals((Object)hcw.getType())).map(hcw -> hcw.getHealthCheck().call()).collect(Collectors.toList());
    }
}

