/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.health.checks;

import com.kumuluz.ee.configuration.utils.ConfigurationUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;

public class ElasticSearchHealthCheck
implements HealthCheck {
    private static final Logger LOG = Logger.getLogger(ElasticSearchHealthCheck.class.getName());
    private static final Client CLIENT = ClientBuilder.newClient();
    private static final String DEFAULT_CLUSTER_HEALTH_URL = "http://localhost:9200/_cluster/health";
    private static final String GREEN = "green";
    private static final String YELLOW = "yellow";
    private static final String STATUS = "status";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HealthCheckResponse call() {
        String connectionUrl = ConfigurationUtil.getInstance().get("kumuluzee.health.checks.elastic-search-health-check.connection-url").orElse(DEFAULT_CLUSTER_HEALTH_URL);
        WebTarget webTarget = CLIENT.target(connectionUrl);
        try (Response response = null;){
            Object result;
            Object status;
            response = webTarget.request().get();
            if (response.getStatus() == 200 && (status = ((HashMap)(result = (HashMap)response.readEntity((GenericType)new GenericType<LinkedHashMap>(){}))).get(STATUS)) != null && (GREEN.equals(status.toString()) || YELLOW.equals(status.toString()))) {
                HealthCheckResponse healthCheckResponse = HealthCheckResponse.named((String)ElasticSearchHealthCheck.class.getSimpleName()).up().build();
                return healthCheckResponse;
            }
            result = HealthCheckResponse.named((String)ElasticSearchHealthCheck.class.getSimpleName()).down().build();
            return result;
        }
    }
}

