/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.health.utils;

import com.kumuluz.ee.configuration.utils.ConfigurationUtil;
import com.kumuluz.ee.health.HealthRegistry;
import com.kumuluz.ee.health.checks.DataSourceHealthCheck;
import com.kumuluz.ee.health.checks.DiskSpaceHealthCheck;
import com.kumuluz.ee.health.checks.ElasticSearchHealthCheck;
import com.kumuluz.ee.health.checks.EtcdHealthCheck;
import com.kumuluz.ee.health.checks.HttpHealthCheck;
import com.kumuluz.ee.health.checks.MongoHealthCheck;
import com.kumuluz.ee.health.checks.RabbitHealthCheck;
import com.kumuluz.ee.health.checks.RedisHealthCheck;
import com.kumuluz.ee.health.enums.HealthCheckType;
import java.lang.annotation.Annotation;
import java.sql.DriverManager;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.util.AnnotationLiteral;
import org.eclipse.microprofile.health.Health;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.Liveness;
import org.eclipse.microprofile.health.Readiness;

public class HealthCheckInitializationExtension
implements Extension {
    private static final Logger LOG = Logger.getLogger(HealthCheckInitializationExtension.class.getName());

    public void registerHealthChecks(@Observes @Initialized(value=ApplicationScoped.class) Object init, BeanManager beanManager) {
        this.registerHealthCheck("kumuluzee.health.checks.data-source-health-check", DataSourceHealthCheck.class, () -> {
            if (!DriverManager.getDrivers().hasMoreElements()) {
                LOG.severe("No database driver library appears to be provided.");
                return false;
            }
            return true;
        });
        this.registerHealthCheck("kumuluzee.health.checks.disk-space-health-check", DiskSpaceHealthCheck.class, () -> true);
        this.registerHealthCheck("kumuluzee.health.checks.elastic-search-health-check", ElasticSearchHealthCheck.class, () -> true);
        this.registerHealthCheck("kumuluzee.health.checks.etcd-health-check", EtcdHealthCheck.class, () -> true);
        this.registerHealthCheck("kumuluzee.health.checks.http-health-check", HttpHealthCheck.class, () -> true);
        this.registerHealthCheck("kumuluzee.health.checks.mongo-health-check", MongoHealthCheck.class, () -> {
            try {
                Class.forName("com.mongodb.MongoClient");
                return true;
            }
            catch (ClassNotFoundException e) {
                LOG.severe("The required mongo-java-driver library appears to be missing.");
                return false;
            }
        });
        this.registerHealthCheck("kumuluzee.health.checks.rabbit-health-check", RabbitHealthCheck.class, () -> {
            try {
                Class.forName("com.rabbitmq.client.Connection");
                return true;
            }
            catch (ClassNotFoundException e) {
                LOG.severe("The required amqp-client library appears to be missing.");
                return false;
            }
        });
        this.registerHealthCheck("kumuluzee.health.checks.redis-health-check", RedisHealthCheck.class, () -> {
            try {
                Class.forName("redis.clients.jedis.JedisPool");
                return true;
            }
            catch (ClassNotFoundException e) {
                LOG.severe("The required jedis library appears to be missing.");
                return false;
            }
        });
        this.registerHealthCheckBeans(beanManager, (AnnotationLiteral)new AnnotationLiteral<Liveness>(){}, HealthCheckType.LIVENESS);
        this.registerHealthCheckBeans(beanManager, (AnnotationLiteral)new AnnotationLiteral<Readiness>(){}, HealthCheckType.READINESS);
        this.registerHealthCheckBeans(beanManager, (AnnotationLiteral)new AnnotationLiteral<Health>(){}, HealthCheckType.BOTH);
    }

    private void registerHealthCheckBeans(BeanManager beanManager, AnnotationLiteral qualifier, HealthCheckType type) {
        Set beans = beanManager.getBeans(HealthCheck.class, new Annotation[]{qualifier});
        for (Bean bean : beans) {
            HealthCheck healthCheckBean = (HealthCheck)beanManager.getReference(bean, HealthCheck.class, beanManager.createCreationalContext((Contextual)bean));
            HealthRegistry.getInstance().register(bean.getBeanClass().getSimpleName(), healthCheckBean, type);
        }
    }

    private void registerHealthCheck(String configKeyPrefix, Class<? extends HealthCheck> healthCheckClass, Supplier<Boolean> check) {
        if (ConfigurationUtil.getInstance().get(configKeyPrefix).isPresent() && check.get().booleanValue()) {
            try {
                HealthRegistry.getInstance().register(healthCheckClass.getSimpleName(), healthCheckClass.newInstance(), this.getHealthCheckType(configKeyPrefix));
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOG.log(Level.SEVERE, "Could not instantiate " + configKeyPrefix, e);
            }
        }
    }

    private HealthCheckType getHealthCheckType(String configKeyPrefix) {
        String type = ConfigurationUtil.getInstance().get(configKeyPrefix + ".type").orElse("readiness");
        HealthCheckType parsedType = HealthCheckType.parse(type);
        if (parsedType == null) {
            LOG.severe("Type of the health check " + configKeyPrefix + " is invalid (" + type + "). Using the default type: readiness.");
            parsedType = HealthCheckType.READINESS;
        }
        return parsedType;
    }
}

