/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.health;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.kumuluz.ee.configuration.utils.ConfigurationUtil;
import com.kumuluz.ee.health.HealthRegistry;
import com.kumuluz.ee.health.enums.HealthCheckType;
import com.kumuluz.ee.health.models.HealthResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.microprofile.health.HealthCheckResponse;

public class HealthServlet
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger(HealthServlet.class.getName());
    private static ConfigurationUtil configurationUtil;
    private static HealthRegistry healthCheckRegistry;
    private static ObjectMapper mapper;
    private String servletMapping;

    public void init() throws ServletException {
        configurationUtil = ConfigurationUtil.getInstance();
        healthCheckRegistry = HealthRegistry.getInstance();
        mapper = new ObjectMapper().registerModule((Module)new Jdk8Module());
        this.servletMapping = this.getInitParameter("com.kumuluz.ee.health.servletMapping");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        response.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
        ServletOutputStream output = null;
        try {
            output = response.getOutputStream();
            response.setStatus(200);
            List<HealthCheckResponse> results = healthCheckRegistry.getResults(this.getRequestType(request));
            HealthResponse healthResponse = new HealthResponse();
            healthResponse.setChecks(results);
            healthResponse.setStatus(HealthCheckResponse.State.UP);
            for (HealthCheckResponse result : results) {
                if (!HealthCheckResponse.State.DOWN.equals((Object)result.getState())) continue;
                response.setStatus(503);
                healthResponse.setStatus(HealthCheckResponse.State.DOWN);
                break;
            }
            if (configurationUtil.getBoolean("kumuluzee.health.servlet.enabled").orElse(true).booleanValue() || configurationUtil.getBoolean("kumuluzee.debug").orElse(false).booleanValue()) {
                response.setContentType("application/json");
                this.getWriter(request).writeValue((OutputStream)output, (Object)healthResponse);
            }
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "An exception occurred when trying to evaluate and log health response.", exception);
            response.setStatus(500);
        }
        catch (Error exception) {
            LOG.log(Level.SEVERE, "An error occurred when trying to evaluate and log health response.", exception);
            response.setStatus(500);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    LOG.severe("Cannot close output stream: " + e.getMessage());
                }
            }
        }
    }

    private ObjectWriter getWriter(HttpServletRequest request) {
        boolean prettyPrintOff = "false".equals(request.getParameter("pretty"));
        return prettyPrintOff ? mapper.writer() : mapper.writerWithDefaultPrettyPrinter();
    }

    private HealthCheckType getRequestType(HttpServletRequest request) {
        if (request.getRequestURI() == null) {
            return HealthCheckType.BOTH;
        }
        if (request.getRequestURI().endsWith(this.servletMapping + "/live")) {
            return HealthCheckType.LIVENESS;
        }
        if (request.getRequestURI().endsWith(this.servletMapping + "/ready")) {
            return HealthCheckType.READINESS;
        }
        return HealthCheckType.BOTH;
    }
}

