/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.health.builders;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;

public class KumuluzHealthCheckResponseBuilder
extends HealthCheckResponseBuilder {
    private String name;
    private Map<String, Object> data = new HashMap<String, Object>();
    private HealthCheckResponse.State state;

    public HealthCheckResponseBuilder name(String name) {
        this.name = name;
        return this;
    }

    public HealthCheckResponseBuilder withData(String name, String value) {
        this.data.put(name, value);
        return this;
    }

    public HealthCheckResponseBuilder withData(String name, long value) {
        this.data.put(name, value);
        return this;
    }

    public HealthCheckResponseBuilder withData(String name, boolean value) {
        this.data.put(name, value);
        return this;
    }

    public HealthCheckResponseBuilder up() {
        this.state = HealthCheckResponse.State.UP;
        return this;
    }

    public HealthCheckResponseBuilder down() {
        this.state = HealthCheckResponse.State.DOWN;
        return this;
    }

    public HealthCheckResponseBuilder state(boolean value) {
        this.state = value ? HealthCheckResponse.State.UP : HealthCheckResponse.State.DOWN;
        return this;
    }

    public HealthCheckResponse build() {
        return new KumuluzHealthCheckResponse();
    }

    class KumuluzHealthCheckResponse
    extends HealthCheckResponse {
        KumuluzHealthCheckResponse() {
        }

        public String getName() {
            return KumuluzHealthCheckResponseBuilder.this.name;
        }

        @JsonProperty(value="status")
        public HealthCheckResponse.State getState() {
            return KumuluzHealthCheckResponseBuilder.this.state;
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public Optional<Map<String, Object>> getData() {
            return Optional.ofNullable(KumuluzHealthCheckResponseBuilder.this.data == null || KumuluzHealthCheckResponseBuilder.this.data.isEmpty() ? null : KumuluzHealthCheckResponseBuilder.this.data);
        }
    }
}

