/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.health.checks;

import com.kumuluz.ee.configuration.utils.ConfigurationUtil;
import com.kumuluz.ee.health.annotations.BuiltInHealthCheck;
import com.kumuluz.ee.health.checks.KumuluzHealthCheck;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;

@ApplicationScoped
@BuiltInHealthCheck
public class DiskSpaceHealthCheck
extends KumuluzHealthCheck
implements HealthCheck {
    private static final Logger LOG = Logger.getLogger(DiskSpaceHealthCheck.class.getName());
    private static final long DEFAULT_THRESHOLD = 100000000L;

    public HealthCheckResponse call() {
        long threshold = ConfigurationUtil.getInstance().getLong(this.name() + ".threshold").orElse(100000000L);
        try {
            if (Files.getFileStore(Paths.get("/", new String[0])).getUsableSpace() >= threshold) {
                return HealthCheckResponse.up((String)DiskSpaceHealthCheck.class.getSimpleName());
            }
            LOG.severe("Disk space is getting low.");
            return HealthCheckResponse.down((String)DiskSpaceHealthCheck.class.getSimpleName());
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "An exception occurred when trying to read disk space.", exception);
            return HealthCheckResponse.down((String)DiskSpaceHealthCheck.class.getSimpleName());
        }
    }

    @Override
    public String name() {
        return this.kumuluzBaseHealthConfigPath + "disk-space-health-check";
    }

    @Override
    public boolean initSuccess() {
        return true;
    }
}

