/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.health.checks;

import com.kumuluz.ee.configuration.utils.ConfigurationUtil;
import com.kumuluz.ee.health.enums.HealthCheckType;
import java.util.logging.Logger;

public abstract class KumuluzHealthCheck {
    private static final Logger LOG = Logger.getLogger(KumuluzHealthCheck.class.getName());
    protected String kumuluzBaseHealthConfigPath = "kumuluzee.health.checks.";

    public abstract String name();

    public abstract boolean initSuccess();

    public HealthCheckType getHealthCheckType() {
        String type = ConfigurationUtil.getInstance().get(this.name() + ".type").orElse("readiness");
        HealthCheckType parsedType = HealthCheckType.parse(type);
        if (parsedType == null) {
            LOG.severe("Type of the health check " + this.name() + " is invalid (" + type + "). Using the default type: readiness.");
            parsedType = HealthCheckType.READINESS;
        }
        return parsedType;
    }
}

