/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.health.checks;

import com.kumuluz.ee.configuration.utils.ConfigurationUtil;
import com.kumuluz.ee.health.annotations.BuiltInHealthCheck;
import com.kumuluz.ee.health.checks.KumuluzHealthCheck;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;

@ApplicationScoped
@BuiltInHealthCheck
public class MongoHealthCheck
extends KumuluzHealthCheck
implements HealthCheck {
    private static final Logger LOG = Logger.getLogger(MongoHealthCheck.class.getName());
    private static final String DEFAULT_MONGO_URL = "mongodb://localhost:27017/local?serverSelectionTimeoutMS=2000";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HealthCheckResponse call() {
        String connectionUrl = ConfigurationUtil.getInstance().get(this.name() + ".connection-url").orElse(DEFAULT_MONGO_URL);
        try (MongoClient mongoClient = null;){
            MongoClientURI mongoClientURI = new MongoClientURI(connectionUrl);
            mongoClient = new MongoClient(mongoClientURI);
            if (this.databaseExist(mongoClient, mongoClientURI.getDatabase()).booleanValue()) {
                HealthCheckResponse healthCheckResponse = HealthCheckResponse.up((String)MongoHealthCheck.class.getSimpleName());
                return healthCheckResponse;
            }
            LOG.severe("Mongo database not found.");
            HealthCheckResponse healthCheckResponse = HealthCheckResponse.down((String)MongoHealthCheck.class.getSimpleName());
            return healthCheckResponse;
        }
    }

    private Boolean databaseExist(MongoClient mongoClient, String databaseName) {
        if (mongoClient != null && databaseName != null) {
            for (String s : mongoClient.listDatabaseNames()) {
                if (!s.equals(databaseName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String name() {
        return this.kumuluzBaseHealthConfigPath + "mongo-health-check";
    }

    @Override
    public boolean initSuccess() {
        try {
            Class.forName("com.mongodb.MongoClient");
            return true;
        }
        catch (ClassNotFoundException e) {
            LOG.severe("The required mongo-java-driver library appears to be missing.");
            return false;
        }
    }
}

