/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.health.checks;

import com.kumuluz.ee.configuration.utils.ConfigurationUtil;
import com.kumuluz.ee.health.annotations.BuiltInHealthCheck;
import com.kumuluz.ee.health.checks.KumuluzHealthCheck;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;

@ApplicationScoped
@BuiltInHealthCheck
public class RabbitHealthCheck
extends KumuluzHealthCheck
implements HealthCheck {
    private static final Logger LOG = Logger.getLogger(RabbitHealthCheck.class.getName());
    private static final String DEFAULT_RABBIT_URL = "amqp://guest:guest@localhost:5672?connection_timeout=2000";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HealthCheckResponse call() {
        String connectionUrl = ConfigurationUtil.getInstance().get(this.name() + ".connection-url").orElse(DEFAULT_RABBIT_URL);
        Connection connection = null;
        try {
            ConnectionFactory factory = new ConnectionFactory();
            factory.setUri(connectionUrl);
            connection = factory.newConnection();
            HealthCheckResponse healthCheckResponse = HealthCheckResponse.up((String)RabbitHealthCheck.class.getSimpleName());
            return healthCheckResponse;
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "An exception occurred when trying to establish connection to RabbitMQ.", exception);
            HealthCheckResponse healthCheckResponse = HealthCheckResponse.down((String)RabbitHealthCheck.class.getSimpleName());
            return healthCheckResponse;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    LOG.log(Level.SEVERE, "An exception occurred when trying to close connection to RabbitMQ.", exception);
                }
            }
        }
    }

    @Override
    public String name() {
        return this.kumuluzBaseHealthConfigPath + "rabbit-health-check";
    }

    @Override
    public boolean initSuccess() {
        try {
            Class.forName("com.rabbitmq.client.Connection");
            return true;
        }
        catch (ClassNotFoundException e) {
            LOG.severe("The required amqp-client library appears to be missing.");
            return false;
        }
    }
}

