/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.health.checks;

import com.kumuluz.ee.configuration.utils.ConfigurationUtil;
import com.kumuluz.ee.health.annotations.BuiltInHealthCheck;
import com.kumuluz.ee.health.checks.KumuluzHealthCheck;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import redis.clients.jedis.JedisPool;

@ApplicationScoped
@BuiltInHealthCheck
public class RedisHealthCheck
extends KumuluzHealthCheck
implements HealthCheck {
    private static final Logger LOG = Logger.getLogger(RedisHealthCheck.class.getName());
    private static final String DEFAULT_REDIS_URL = "redis://localhost:6379/0";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HealthCheckResponse call() {
        String connectionUrl = ConfigurationUtil.getInstance().get(this.name() + ".connection-url").orElse(DEFAULT_REDIS_URL);
        try (JedisPool pool = null;){
            pool = new JedisPool(connectionUrl);
            pool.getResource();
            HealthCheckResponse healthCheckResponse = HealthCheckResponse.up((String)RedisHealthCheck.class.getSimpleName());
            return healthCheckResponse;
        }
    }

    @Override
    public String name() {
        return this.kumuluzBaseHealthConfigPath + "redis-health-check";
    }

    @Override
    public boolean initSuccess() {
        try {
            Class.forName("redis.clients.jedis.JedisPool");
            return true;
        }
        catch (ClassNotFoundException e) {
            LOG.severe("The required jedis library appears to be missing.");
            return false;
        }
    }
}

