/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.health.utils;

import com.kumuluz.ee.configuration.utils.ConfigurationUtil;
import com.kumuluz.ee.health.HealthRegistry;
import com.kumuluz.ee.health.annotations.BuiltInHealthCheck;
import com.kumuluz.ee.health.checks.KumuluzHealthCheck;
import com.kumuluz.ee.health.enums.HealthCheckType;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.util.AnnotationLiteral;
import org.eclipse.microprofile.health.Health;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.Liveness;
import org.eclipse.microprofile.health.Readiness;

public class HealthCheckInitializationExtension
implements Extension {
    private static final Logger LOG = Logger.getLogger(HealthCheckInitializationExtension.class.getName());
    protected final String MP_HEALTH_DISABLE_DEFAULT_HEALTH = "mp.health.disable-default-procedures";

    public void registerHealthChecks(@Observes @Initialized(value=ApplicationScoped.class) Object init, BeanManager beanManager) {
        this.registerHealthCheckBeans(beanManager, (AnnotationLiteral)new AnnotationLiteral<BuiltInHealthCheck>(){}, HealthCheckType.READINESS);
        this.registerHealthCheckBeans(beanManager, (AnnotationLiteral)new AnnotationLiteral<Liveness>(){}, HealthCheckType.LIVENESS);
        this.registerHealthCheckBeans(beanManager, (AnnotationLiteral)new AnnotationLiteral<Readiness>(){}, HealthCheckType.READINESS);
        this.registerHealthCheckBeans(beanManager, (AnnotationLiteral)new AnnotationLiteral<Health>(){}, null);
    }

    private void registerHealthCheckBeans(BeanManager beanManager, AnnotationLiteral qualifier, HealthCheckType type) {
        Set beans = beanManager.getBeans(HealthCheck.class, new Annotation[]{qualifier});
        boolean disableDefaultHealthChecks = ConfigurationUtil.getInstance().getBoolean("mp.health.disable-default-procedures").orElse(false);
        for (Bean bean : beans) {
            HealthCheckType hcType = type;
            if (bean.getBeanClass().isAnnotationPresent(BuiltInHealthCheck.class)) {
                KumuluzHealthCheck kumuluzHealthCheckBean;
                if (disableDefaultHealthChecks || (kumuluzHealthCheckBean = this.getBuildInHealthCheckBeanInstance(bean)) == null) continue;
                hcType = kumuluzHealthCheckBean.getHealthCheckType();
            }
            HealthCheck healthCheckBean = (HealthCheck)beanManager.getReference(bean, HealthCheck.class, beanManager.createCreationalContext((Contextual)bean));
            HealthRegistry.getInstance().register(healthCheckBean.getClass().getSimpleName(), healthCheckBean, hcType);
        }
    }

    private KumuluzHealthCheck getBuildInHealthCheckBeanInstance(Bean<?> bean) {
        if (KumuluzHealthCheck.class.isAssignableFrom(bean.getBeanClass())) {
            try {
                KumuluzHealthCheck instance = (KumuluzHealthCheck)bean.getBeanClass().newInstance();
                String kumuluzHealthCheckName = instance.name();
                if (ConfigurationUtil.getInstance().get(kumuluzHealthCheckName).isPresent() && instance.initSuccess()) {
                    return instance;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

