/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.loader;

import com.kumuluz.ee.loader.EeClassLoader;
import com.kumuluz.ee.loader.exception.EeClassLoaderException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class EeBootLoader {
    public static void main(String[] args) throws Throwable {
        try {
            ResourceBundle bootLoaderProperties = ResourceBundle.getBundle("META-INF/kumuluzee/boot-loader");
            String mainClass = bootLoaderProperties.getString("main-class");
            EeBootLoader.launch(args, mainClass);
        }
        catch (MissingResourceException e) {
            throw new EeClassLoaderException("KumuluzEE Boot Loader config properties are malformed or missing.", e);
        }
    }

    private static void launch(String[] args, String mainClass) throws Throwable {
        EeClassLoader classLoader = new EeClassLoader();
        classLoader.invokeMain(mainClass, args);
    }
}

