/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.loader;

import com.kumuluz.ee.loader.exception.EeClassLoaderException;
import com.kumuluz.ee.loader.jar.FileInfo;
import com.kumuluz.ee.loader.jar.JarEntryInfo;
import com.kumuluz.ee.loader.jar.JarFileInfo;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;

public class EeClassLoader
extends ClassLoader {
    private static final String TMP_DIRECTORY = "tmp/EeClassLoader";
    private Boolean DEBUG = false;
    private File tempDir;
    private List<JarFileInfo> jarFiles;
    private List<FileInfo> files;
    private Set<File> deleteOnExit;
    private Map<String, Class<?>> classes;
    private JarFileInfo jarFileInfo;

    public EeClassLoader() {
        this(ClassLoader.getSystemClassLoader());
    }

    public EeClassLoader(ClassLoader parent) {
        super(parent);
        String mainJarURLString;
        String debugString = System.getProperty("com.kumuluz.ee.loader.debug");
        if (debugString != null) {
            this.DEBUG = Boolean.valueOf(debugString);
        }
        long startTime = System.currentTimeMillis();
        this.debug("Initialising KumuluzEE classloader");
        this.classes = new HashMap();
        this.jarFiles = Collections.synchronizedList(new ArrayList());
        this.files = Collections.synchronizedList(new ArrayList());
        this.deleteOnExit = new HashSet<File>();
        ProtectionDomain protectionDomain = this.getClass().getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URL mainJarURL = codeSource.getLocation();
        String protocol = mainJarURL.getProtocol();
        try {
            mainJarURLString = URLDecoder.decode(mainJarURL.getFile(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            String msg = String.format("Failed to decode URL: %s %s", mainJarURL, e.toString());
            throw new EeClassLoaderException(msg, e);
        }
        File mainJarFile = new File(mainJarURLString);
        try {
            this.jarFileInfo = new JarFileInfo(new JarFile(mainJarFile, true, 1, JarFile.runtimeVersion()), mainJarFile.getName(), null, protectionDomain, null);
            this.debug(String.format("Loading from main JAR: '%s' PROTOCOL: '%s'", mainJarURLString, protocol));
        }
        catch (IOException e) {
            String msg = String.format("Not a JAR: %s %s", mainJarURLString, e.toString());
            throw new EeClassLoaderException(msg, e);
        }
        try {
            this.extractMainJar(this.jarFileInfo);
            this.loadJar(this.jarFileInfo);
        }
        catch (Exception e) {
            String msg = String.format("Not a valid URL: %s %s", mainJarURL, e.toString());
            throw new EeClassLoaderException(msg, e);
        }
        this.debug(String.format("Initialised KumuluzEE classloader @%dms", System.currentTimeMillis() - startTime));
    }

    private void createTempDirectory() throws URISyntaxException {
        if (this.tempDir == null) {
            String path;
            ProtectionDomain protectionDomain = this.getClass().getProtectionDomain();
            CodeSource codeSource = protectionDomain.getCodeSource();
            URI location = codeSource == null ? null : codeSource.getLocation().toURI();
            String string = path = location == null ? null : location.getSchemeSpecificPart();
            if (path == null) {
                throw new IllegalStateException("Unable to determine code source archive");
            }
            File jarDir = new File(path);
            String jarFolder = jarDir.getParentFile().getPath();
            File dir = new File(jarFolder, TMP_DIRECTORY);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            dir.deleteOnExit();
            this.chmod777(dir);
            if (!dir.exists() || !dir.isDirectory()) {
                throw new EeClassLoaderException("Cannot create temp directory " + dir.getAbsolutePath());
            }
            this.tempDir = dir;
        }
    }

    private File createFile(JarEntry jarEntry, InputStream is) throws EeClassLoaderException {
        File tmpFile = null;
        try {
            if (jarEntry.isDirectory()) {
                tmpFile = new File(this.tempDir + File.separator + jarEntry);
                tmpFile.mkdirs();
                tmpFile.deleteOnExit();
                this.chmod777(tmpFile);
                return tmpFile;
            }
            String fileName = jarEntry.getName();
            File tempDir = this.tempDir;
            int lastPathIndex = jarEntry.getName().lastIndexOf("/");
            if (lastPathIndex > -1) {
                String dirPath = jarEntry.getName().substring(0, lastPathIndex);
                tempDir = new File(tempDir.getPath() + File.separator + dirPath);
                tempDir.mkdirs();
                tempDir.deleteOnExit();
                this.chmod777(tempDir);
                fileName = fileName.substring(lastPathIndex + 1);
            }
            tmpFile = new File(tempDir + File.separator + fileName);
            tmpFile.deleteOnExit();
            this.chmod777(tmpFile);
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tmpFile));
            while (is.available() > 0) {
                os.write(is.read());
            }
            os.close();
            return tmpFile;
        }
        catch (IOException e) {
            throw new EeClassLoaderException(String.format("Cannot create file '%s' for %s", tmpFile, jarEntry), e);
        }
    }

    private File createJarFile(JarEntryInfo jarEntryInfo) throws EeClassLoaderException {
        File tmpFile = null;
        try {
            tmpFile = new File(this.tempDir.getPath() + File.separator + jarEntryInfo.getName());
            tmpFile.deleteOnExit();
            this.chmod777(tmpFile);
            byte[] bytes = jarEntryInfo.getJarBytes();
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tmpFile));
            os.write(bytes);
            os.close();
            return tmpFile;
        }
        catch (IOException e) {
            throw new EeClassLoaderException(String.format("Cannot create temp file '%s' for %s", tmpFile, jarEntryInfo.getJarEntry()), e);
        }
    }

    private void extractMainJar(JarFileInfo jarFileInfo) throws URISyntaxException {
        String LIB_DIRECTORY = "lib/";
        this.createTempDirectory();
        ((Stream)jarFileInfo.getJarFile().stream().parallel()).filter(je -> !je.getName().toLowerCase().startsWith("lib/")).forEach(je -> {
            try {
                JarEntryInfo jarEntryInfo = new JarEntryInfo(jarFileInfo, (JarEntry)je);
                File tempFile = this.createFile((JarEntry)je, jarFileInfo.getJarFile().getInputStream((ZipEntry)je));
                this.debug(String.format("Loading inner JAR %s from temp file %s", jarEntryInfo.getJarEntry(), this.getFilenameForLog(tempFile)));
                this.files.add(new FileInfo(tempFile, je.getName()));
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Cannot load jar entries from jar %s", je.getName().toLowerCase()), e);
            }
            catch (EeClassLoaderException e) {
                throw new RuntimeException("ERROR on loading inner JAR: " + e.getMessageAll());
            }
        });
    }

    private void loadJar(JarFileInfo jarFileInfo) {
        String JAR_SUFFIX = ".jar";
        this.jarFiles.add(jarFileInfo);
        ((Stream)jarFileInfo.getJarFile().stream().parallel()).filter(je -> !je.isDirectory() && je.getName().toLowerCase().endsWith(".jar")).forEach(je -> {
            try {
                JarEntryInfo jarEntryInfo = new JarEntryInfo(jarFileInfo, (JarEntry)je);
                File tempFile = this.createJarFile(jarEntryInfo);
                this.debug(String.format("Loading inner JAR %s from temp file %s", jarEntryInfo.getJarEntry(), this.getFilenameForLog(tempFile)));
                URL url = tempFile.toURI().toURL();
                ProtectionDomain pdParent = jarFileInfo.getProtectionDomain();
                CodeSource csParent = pdParent.getCodeSource();
                Certificate[] certParent = csParent.getCertificates();
                CodeSource csChild = certParent == null ? new CodeSource(url, csParent.getCodeSigners()) : new CodeSource(url, certParent);
                ProtectionDomain pdChild = new ProtectionDomain(csChild, pdParent.getPermissions(), pdParent.getClassLoader(), pdParent.getPrincipals());
                this.loadJar(new JarFileInfo(new JarFile(tempFile, true, 1, JarFile.runtimeVersion()), jarEntryInfo.getName(), jarFileInfo, pdChild, tempFile));
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Cannot load jar entries from jar %s", je.getName().toLowerCase()), e);
            }
            catch (EeClassLoaderException e) {
                throw new RuntimeException("ERROR on loading inner JAR: " + e.getMessageAll());
            }
        });
    }

    private JarEntryInfo findJarEntry(String name) {
        for (JarFileInfo jarFileInfo : this.jarFiles) {
            JarFile jarFile = jarFileInfo.getJarFile();
            JarEntry jarEntry = jarFile.getJarEntry(name);
            if (jarEntry == null) continue;
            return new JarEntryInfo(jarFileInfo, jarEntry);
        }
        return null;
    }

    private URL findFile(String name) {
        for (FileInfo fileInfo : this.files) {
            if (!fileInfo.getSimpleName().equals(name)) continue;
            try {
                return fileInfo.getFile().toURI().toURL();
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private List<JarEntryInfo> findJarEntries(String name) {
        ArrayList<JarEntryInfo> jarEntryInfoList = new ArrayList<JarEntryInfo>();
        for (JarFileInfo jarFileInfo : this.jarFiles) {
            JarFile jarFile = jarFileInfo.getJarFile();
            JarEntry jarEntry = jarFile.getJarEntry(name);
            if (jarEntry == null) continue;
            jarEntryInfoList.add(new JarEntryInfo(jarFileInfo, jarEntry));
        }
        return jarEntryInfoList;
    }

    private List<URL> findFiles(String name) {
        ArrayList<URL> urlList = new ArrayList<URL>();
        for (FileInfo fileInfo : this.files) {
            if (!fileInfo.getSimpleName().equals(name)) continue;
            try {
                URL fileUrl = fileInfo.getFile().toURI().toURL();
                urlList.add(fileUrl);
            }
            catch (Exception exception) {}
        }
        return urlList;
    }

    private JarEntryInfo findJarNativeEntry(String libraryName) {
        String name = System.mapLibraryName(libraryName);
        for (JarFileInfo jarFileInfo : this.jarFiles) {
            JarFile jarFile = jarFileInfo.getJarFile();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                String jarEntryName;
                String[] token;
                JarEntry jarEntry = entries.nextElement();
                if (jarEntry.isDirectory() || (token = (jarEntryName = jarEntry.getName()).split("/")).length <= 0 || !token[token.length - 1].equals(name)) continue;
                this.debug(String.format("Loading native library '%s' found as '%s' in JAR %s", libraryName, jarEntryName, jarFileInfo.getSimpleName()));
                return new JarEntryInfo(jarFileInfo, jarEntry);
            }
        }
        return null;
    }

    private Class<?> findJarClass(String className) throws EeClassLoaderException {
        Class<?> clazz = this.classes.get(className);
        if (clazz != null) {
            return clazz;
        }
        String fullClassName = className.replace('.', '/') + ".class";
        JarEntryInfo jarEntryInfo = this.findJarEntry(fullClassName);
        String jarSimpleName = null;
        if (jarEntryInfo != null) {
            jarSimpleName = jarEntryInfo.getJarFileInfo().getSimpleName();
            this.definePackage(className, jarEntryInfo);
            byte[] bytes = jarEntryInfo.getJarBytes();
            try {
                clazz = this.defineClass(className, bytes, 0, bytes.length, jarEntryInfo.getJarFileInfo().getProtectionDomain());
            }
            catch (ClassFormatError e) {
                throw new EeClassLoaderException(null, e);
            }
        }
        if (clazz == null) {
            throw new EeClassLoaderException(className);
        }
        this.classes.put(className, clazz);
        this.debug(String.format("Loaded %s by %s from JAR %s", className, this.getClass().getName(), jarSimpleName));
        return clazz;
    }

    private boolean isLaunchedFromJar() {
        return this.jarFiles != null && !this.jarFiles.isEmpty();
    }

    public void invokeMain(String className, String[] args) throws Throwable {
        Class<?> clazz = this.loadClass(className);
        this.debug(String.format("Launch: %s.main(); Loader: %s", className, clazz.getClassLoader()));
        Method method = clazz.getMethod("main", String[].class);
        if (method == null) {
            throw new NoSuchMethodException("The main() method in class \"" + className + "\" not found.");
        }
        try {
            method.invoke(null, new Object[]{args});
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected synchronized Class<?> loadClass(String className, boolean bResolve) throws ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected Class<?> findClass(String s) throws ClassNotFoundException {
        return this.loadClass(s);
    }

    @Override
    protected URL findResource(String name) {
        this.debug(String.format("findResource: %s", name));
        if (this.isLaunchedFromJar()) {
            URL file = this.findFile(this.normalizeResourceName(name));
            if (file != null) {
                this.debug(String.format("found resource: %s", file));
                return file;
            }
            JarEntryInfo inf = this.findJarEntry(this.normalizeResourceName(name));
            if (inf != null) {
                URL url = inf.getURL();
                this.debug(String.format("found resource: %s", url));
                return url;
            }
            this.debug(String.format("not found resource: %s", name));
            return null;
        }
        return super.findResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.findResources(name);
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        this.debug(String.format("getResources: %s", name));
        if (this.isLaunchedFromJar()) {
            List<URL> fileUrls = this.findFiles(this.normalizeResourceName(name));
            List<JarEntryInfo> jarEntries = this.findJarEntries(this.normalizeResourceName(name));
            ArrayList<URL> urls = new ArrayList<URL>(fileUrls);
            for (JarEntryInfo jarEntryInfo : jarEntries) {
                URL url;
                if (jarEntryInfo.getJarFileInfo().equals(this.jarFileInfo) || (url = jarEntryInfo.getURL()) == null) continue;
                urls.add(url);
            }
            return Collections.enumeration(urls);
        }
        return super.findResources(name);
    }

    @Override
    protected String findLibrary(String name) {
        this.debug(String.format("findLibrary: %s", name));
        if (this.isLaunchedFromJar()) {
            JarEntryInfo jarEntryInfo = this.findJarNativeEntry(name);
            if (jarEntryInfo != null) {
                try {
                    File file = this.createJarFile(jarEntryInfo);
                    this.debug(String.format("Loading native library %s from temp file %s", jarEntryInfo.getJarEntry(), this.getFilenameForLog(file)));
                    this.deleteOnExit.add(file);
                    return file.getAbsolutePath();
                }
                catch (EeClassLoaderException e) {
                    this.debug(String.format("Failure to load native library %s: %s", name, e.toString()));
                }
            }
            return null;
        }
        return super.findLibrary(name);
    }

    public List<String> getJarFilesLocations(List<String> filenames) {
        ArrayList<String> locations = new ArrayList<String>();
        for (String filename : filenames) {
            JarFileInfo jarLib = this.jarFiles.stream().filter(jfi -> jfi.getSimpleName().contains("!")).filter(jfi -> jfi.getSimpleName().split("!")[1].equals("lib_" + filename)).findFirst().orElse(null);
            if (jarLib == null) {
                String regex = "^.*!lib_" + Pattern.quote(filename) + "-[^/]+\\.jar$";
                List matchedFiles = this.jarFiles.stream().filter(jfi -> jfi.getSimpleName().matches(regex)).collect(Collectors.toList());
                if (matchedFiles.size() == 1) {
                    jarLib = (JarFileInfo)matchedFiles.get(0);
                } else if (matchedFiles.size() > 1) {
                    jarLib = matchedFiles.stream().min(Comparator.comparingInt(jfi -> jfi.getSimpleName().length())).orElseThrow(() -> new RuntimeException("Could not find library with shortest name"));
                    Logger log = Logger.getLogger(EeClassLoader.class.getSimpleName());
                    log.severe(String.format("Multiple jar files with artifact name similar to '%s' found ([%s]). Using %s. Consider matching by full name.", filename, matchedFiles.stream().map(jfi -> jfi.getSimpleName().split("!")[1].substring(4)).collect(Collectors.joining(", ")), jarLib.getSimpleName().split("!")[1].substring(4)));
                }
            }
            if (jarLib == null) {
                throw new IllegalArgumentException("Could not locate library " + filename);
            }
            locations.add(jarLib.getFileDeleteOnExit().getAbsolutePath());
        }
        return Collections.unmodifiableList(locations);
    }

    private void definePackage(String className, JarEntryInfo jarEntryInfo) throws IllegalArgumentException {
        String packageName;
        int index = className.lastIndexOf(46);
        String string = packageName = index > 0 ? className.substring(0, index) : "";
        if (this.getPackage(packageName) == null) {
            JarFileInfo jarFileInfo = jarEntryInfo.getJarFileInfo();
            this.definePackage(packageName, jarFileInfo.getSpecificationTitle(), jarFileInfo.getSpecificationVersion(), jarFileInfo.getSpecificationVendor(), jarFileInfo.getImplementationTitle(), jarFileInfo.getImplementationVersion(), jarFileInfo.getImplementationVendor(), jarFileInfo.getSealURL());
        }
    }

    private String normalizeResourceName(String name) {
        return name.replace('\\', '/');
    }

    private void chmod777(File file) {
        file.setReadable(true, false);
        file.setWritable(true, false);
        file.setExecutable(true, false);
    }

    private String getFilenameForLog(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    private void debug(String msg) {
        if (this.DEBUG.booleanValue()) {
            System.out.println(msg);
        }
    }
}

