/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.loader.jar;

import com.kumuluz.ee.loader.exception.EeClassLoaderException;
import com.kumuluz.ee.loader.jar.JarFileInfo;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.jar.JarEntry;

public class JarEntryInfo {
    private JarFileInfo jarFileInfo;
    private JarEntry jarEntry;

    public JarEntryInfo(JarFileInfo jarFileInfo, JarEntry jarEntry) {
        this.jarFileInfo = jarFileInfo;
        this.jarEntry = jarEntry;
    }

    public JarFileInfo getJarFileInfo() {
        return this.jarFileInfo;
    }

    public void setJarFileInfo(JarFileInfo jarFileInfo) {
        this.jarFileInfo = jarFileInfo;
    }

    public JarEntry getJarEntry() {
        return this.jarEntry;
    }

    public void setJarEntry(JarEntry jarEntry) {
        this.jarEntry = jarEntry;
    }

    public URL getURL() {
        try {
            String jarFileName = new File(this.jarFileInfo.getJarFile().getName()).toURI().toString();
            URI uri = new URI("jar:" + jarFileName + "!/" + this.jarEntry);
            return uri.toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            return null;
        }
    }

    public String getName() {
        return this.jarEntry.getName().replace('/', '_');
    }

    public byte[] getJarBytes() throws EeClassLoaderException {
        byte[] bytes;
        FilterInputStream dataInputStream = null;
        try {
            long jarEntrySize = this.jarEntry.getSize();
            if (jarEntrySize <= 0L || jarEntrySize >= Integer.MAX_VALUE) {
                throw new EeClassLoaderException("Invalid size " + jarEntrySize + " for entry " + this.jarEntry);
            }
            bytes = new byte[(int)jarEntrySize];
            InputStream inputStream = this.jarFileInfo.getJarFile().getInputStream(this.jarEntry);
            dataInputStream = new DataInputStream(inputStream);
            ((DataInputStream)dataInputStream).readFully(bytes);
        }
        catch (IOException e) {
            throw new EeClassLoaderException(null, e);
        }
        finally {
            if (dataInputStream != null) {
                try {
                    dataInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bytes;
    }

    public String toString() {
        return "JAR: " + this.jarFileInfo.getJarFile().getName() + " ENTRY: " + this.jarEntry;
    }
}

