/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.loader.jar;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarFileInfo {
    private JarFile jarFile;
    private String simpleName;
    private File fileDeleteOnExit;
    private Manifest manifest;
    private ProtectionDomain protectionDomain;

    public JarFileInfo(JarFile jarFile, String simpleName, JarFileInfo jarFileParent, ProtectionDomain protectionDomain, File fileDeleteOnExit) {
        this.simpleName = (String)(jarFileParent == null ? "" : jarFileParent.simpleName + "!") + simpleName;
        this.jarFile = jarFile;
        this.protectionDomain = protectionDomain;
        this.fileDeleteOnExit = fileDeleteOnExit;
        try {
            this.manifest = jarFile.getManifest();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.manifest == null) {
            this.manifest = new Manifest();
        }
    }

    public String getSpecificationTitle() {
        return this.manifest.getMainAttributes().getValue(Attributes.Name.SPECIFICATION_TITLE);
    }

    public String getSpecificationVersion() {
        return this.manifest.getMainAttributes().getValue(Attributes.Name.SPECIFICATION_VERSION);
    }

    public String getSpecificationVendor() {
        return this.manifest.getMainAttributes().getValue(Attributes.Name.SPECIFICATION_VENDOR);
    }

    public String getImplementationTitle() {
        return this.manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_TITLE);
    }

    public String getImplementationVersion() {
        return this.manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
    }

    public String getImplementationVendor() {
        return this.manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
    }

    public URL getSealURL() {
        String seal = this.manifest.getMainAttributes().getValue(Attributes.Name.SEALED);
        if (seal != null) {
            try {
                return new URL(seal);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public JarFile getJarFile() {
        return this.jarFile;
    }

    public void setJarFile(JarFile jarFile) {
        this.jarFile = jarFile;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public void setSimpleName(String simpleName) {
        this.simpleName = simpleName;
    }

    public File getFileDeleteOnExit() {
        return this.fileDeleteOnExit;
    }

    public void setFileDeleteOnExit(File fileDeleteOnExit) {
        this.fileDeleteOnExit = fileDeleteOnExit;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public void setManifest(Manifest manifest) {
        this.manifest = manifest;
    }

    public ProtectionDomain getProtectionDomain() {
        return this.protectionDomain;
    }

    public void setProtectionDomain(ProtectionDomain protectionDomain) {
        this.protectionDomain = protectionDomain;
    }
}

