/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.testing.arquillian;

import com.kumuluz.ee.logs.impl.JavaUtilDefaultLogConfigurator;
import com.kumuluz.ee.testing.arquillian.KumuluzEEContainerConfig;
import com.kumuluz.ee.testing.arquillian.deployment.AbstractDeployment;
import com.kumuluz.ee.testing.arquillian.deployment.ExplodedDeployment;
import com.kumuluz.ee.testing.arquillian.deployment.UberJarDeployment;
import com.kumuluz.ee.testing.arquillian.utils.ArchiveUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

public class KumuluzEEContainer
implements DeployableContainer<KumuluzEEContainerConfig> {
    private final Logger LOG;
    private static boolean loggingInitialized = false;
    private Map<Archive, AbstractDeployment> deployments;

    private static synchronized void initLogging() {
        if (!loggingInitialized) {
            JavaUtilDefaultLogConfigurator.init();
            loggingInitialized = true;
        }
    }

    public KumuluzEEContainer() {
        KumuluzEEContainer.initLogging();
        this.LOG = Logger.getLogger(KumuluzEEContainer.class.getName());
        this.deployments = new HashMap<Archive, AbstractDeployment>();
    }

    public Class<KumuluzEEContainerConfig> getConfigurationClass() {
        return KumuluzEEContainerConfig.class;
    }

    public void setup(KumuluzEEContainerConfig containerConfig) {
        KumuluzEEContainerConfig.init(containerConfig);
    }

    public void start() {
    }

    public void stop() {
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 3.0");
    }

    public void deploy(Descriptor descriptor) {
        throw new UnsupportedOperationException("Deploying descriptors is not supported");
    }

    public void undeploy(Descriptor descriptor) {
        throw new UnsupportedOperationException("Undeploying descriptors is not supported");
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        AbstractDeployment deployment = this.deployments.get(archive);
        if (deployment == null) {
            throw new DeploymentException("Could not find deployed archive " + archive.getName());
        }
        deployment.stop();
        this.deployments.remove(archive);
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        AbstractDeployment deployment;
        this.LOG.info("Deploying " + archive.getName());
        KumuluzEEContainerConfig containerConfig = KumuluzEEContainerConfig.getInstance();
        switch (containerConfig.getPackaging()) {
            case "uberJar": {
                JavaArchive uberJar = ArchiveUtils.generateUberJar(archive);
                this.LOG.fine("UberJar: " + uberJar.toString(true));
                deployment = new UberJarDeployment((Archive<?>)uberJar);
                break;
            }
            case "exploded": {
                JavaArchive exploded = ArchiveUtils.generateExploded(archive);
                this.LOG.fine("Exploded structure: " + exploded.toString(true));
                deployment = new ExplodedDeployment((Archive<?>)exploded);
                break;
            }
            default: {
                throw new DeploymentException("Unrecognised deployment: " + containerConfig.getPackaging());
            }
        }
        deployment.init();
        this.deployments.put(archive, deployment);
        HTTPContext context = deployment.start();
        ProtocolMetaData metaData = new ProtocolMetaData();
        metaData.addContext((Object)context);
        return metaData;
    }
}

