/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.testing.arquillian;

import java.util.Arrays;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;

public class KumuluzEEContainerConfig
implements ContainerConfiguration {
    private static final Logger LOG = Logger.getLogger(KumuluzEEContainerConfig.class.getName());
    private static KumuluzEEContainerConfig instance = null;
    public static final String PACKAGING_UBER_JAR = "uberJar";
    public static final String PACKAGING_EXPLODED = "exploded";
    private static final String[] ALLOWED_PACKAGINGS = new String[]{"exploded", "uberJar"};
    public static final String INCLUDE_LIBS_FALSE = "false";
    public static final String INCLUDE_LIBS_DEFAULT = "default";
    public static final String INCLUDE_LIBS_MP1_0 = "MicroProfile-1.0";
    public static final String INCLUDE_LIBS_MP1_1 = "MicroProfile-1.1";
    public static final String INCLUDE_LIBS_MP1_2 = "MicroProfile-1.2";
    public static final String INCLUDE_LIBS_FROM_POM = "fromPom";
    private static final String[] ALLOWED_INCLUDE_LIBS = new String[]{"false", "default", "MicroProfile-1.0", "MicroProfile-1.1", "MicroProfile-1.2", "fromPom"};
    private static final String defaultKumuluzVersion = "3.0.0";
    private boolean deleteTemporaryFiles = true;
    private long containerStartTimeoutMs = 60000L;
    private String packaging = "exploded";
    private String kumuluzVersion = null;
    private String includeRequiredLibraries = "default";
    private String javaPath = "";
    private String javaArguments = "";

    public static void init(KumuluzEEContainerConfig config) {
        if (instance != null) {
            throw new RuntimeException("KumuluzEEContainerConfig already initialised!");
        }
        instance = config;
    }

    public static KumuluzEEContainerConfig getInstance() {
        if (instance == null) {
            throw new RuntimeException("KumuluzEEContainerConfig not initialised!");
        }
        return instance;
    }

    public void validate() throws ConfigurationException {
        if (this.containerStartTimeoutMs <= 0L) {
            throw new ConfigurationException("containerStartTimeoutMs should be greater than 0");
        }
        if (!Arrays.asList(ALLOWED_PACKAGINGS).contains(this.packaging)) {
            throw new ConfigurationException("Packaging " + this.packaging + " not allowed. Use one of the following: " + Arrays.toString(ALLOWED_PACKAGINGS));
        }
        if (!Arrays.asList(ALLOWED_INCLUDE_LIBS).contains(this.includeRequiredLibraries)) {
            throw new ConfigurationException("includeRequiredLibraries parameter " + this.includeRequiredLibraries + " not recognised. Use one of the following: " + Arrays.toString(ALLOWED_INCLUDE_LIBS));
        }
        boolean autoDiscovered = false;
        if (this.kumuluzVersion == null) {
            try {
                ResourceBundle coreVersionBundle = ResourceBundle.getBundle("META-INF/kumuluzee/versions");
                String version = coreVersionBundle.getString("version");
                if (version.isEmpty()) {
                    throw new MissingResourceException("Version is empty.", KumuluzEEContainerConfig.class.getName(), "version");
                }
                this.kumuluzVersion = version;
                autoDiscovered = true;
            }
            catch (MissingResourceException e) {
                LOG.info("Could not determine KumuluzEE version automatically. Using default version.");
                this.kumuluzVersion = defaultKumuluzVersion;
            }
        }
        LOG.info("Using KumuluzEE version " + this.kumuluzVersion + (autoDiscovered ? " (auto-discovered)" : ""));
    }

    public boolean shouldDeleteTemporaryFiles() {
        return this.deleteTemporaryFiles;
    }

    public void setDeleteTemporaryFiles(boolean deleteTemporaryFiles) {
        this.deleteTemporaryFiles = deleteTemporaryFiles;
    }

    public long getContainerStartTimeoutMs() {
        return this.containerStartTimeoutMs;
    }

    public void setContainerStartTimeoutMs(long containerStartTimeoutMs) {
        this.containerStartTimeoutMs = containerStartTimeoutMs;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    public String getKumuluzVersion() {
        return this.kumuluzVersion;
    }

    public void setKumuluzVersion(String kumuluzVersion) {
        this.kumuluzVersion = kumuluzVersion;
    }

    public String getIncludeRequiredLibraries() {
        return this.includeRequiredLibraries;
    }

    public void setIncludeRequiredLibraries(String includeRequiredLibraries) {
        this.includeRequiredLibraries = includeRequiredLibraries;
    }

    public String getJavaPath() {
        return this.javaPath;
    }

    public void setJavaPath(String javaPath) {
        this.javaPath = javaPath;
    }

    public String getJavaArguments() {
        return this.javaArguments;
    }

    public void setJavaArguments(String javaArguments) {
        this.javaArguments = javaArguments;
    }
}

