/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.testing.arquillian.assets;

import com.kumuluz.ee.EeApplication;
import com.kumuluz.ee.common.KumuluzServer;
import com.kumuluz.ee.common.ServletServer;
import com.kumuluz.ee.common.config.EeConfig;
import com.kumuluz.ee.common.servlet.ServletWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Base64;
import java.util.List;

public class MainWrapper {
    public static final String MSG_PREFIX = "KumuluzEE Arquillian: ";
    public static final String MSG_SERVER_STARTED = "KumuluzEE Arquillian: Server started";
    public static final String MSG_METADATA_PREFIX = "KumuluzEE Arquillian: HTTP Context: ";
    public static final String MSG_EXCEPTION_PREFIX = "KumuluzEE Arquillian: Exception thrown: ";

    public static void main(String[] args) {
        try {
            System.setProperty("kumuluzee.server.jetty.forward-startup-exception", "true");
            EeApplication app = new EeApplication();
            KumuluzServer server = app.getServer();
            if (server instanceof ServletServer) {
                Integer port = EeConfig.getInstance().getServer().getHttp().getPort();
                StringBuilder metadataSb = new StringBuilder();
                metadataSb.append(MSG_METADATA_PREFIX).append(port).append('\t');
                List servlets = ((ServletServer)server).getRegisteredServlets();
                for (ServletWrapper s : servlets) {
                    metadataSb.append(s.getName()).append(':').append(s.getContextPath()).append('\t');
                }
                System.out.println(metadataSb.toString());
            }
            System.out.println(MSG_SERVER_STARTED);
        }
        catch (Exception e) {
            System.out.println(MSG_EXCEPTION_PREFIX + MainWrapper.serializeException(e));
            throw e;
        }
    }

    private static String serializeException(Exception e) {
        try {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            ObjectOutputStream so = new ObjectOutputStream(bo);
            so.writeObject(e);
            so.flush();
            return Base64.getEncoder().encodeToString(bo.toByteArray());
        }
        catch (IOException e1) {
            RuntimeException newEx = new RuntimeException("IO error while serializing exception", e1);
            newEx.printStackTrace();
            return MainWrapper.serializeException(newEx);
        }
    }
}

