/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.testing.arquillian.deployment;

import com.kumuluz.ee.testing.arquillian.KumuluzEEContainerConfig;
import com.kumuluz.ee.testing.arquillian.utils.OutputProcessor;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.shrinkwrap.api.Archive;

public abstract class AbstractDeployment {
    private static final Logger LOG = Logger.getLogger(AbstractDeployment.class.getName());
    private KumuluzEEContainerConfig containerConfig;
    protected boolean shouldDelete;
    protected static final String TMP_DIR = "KumuluzEEArquillian";
    protected Path tmpDir;
    protected Archive<?> archive;
    private Process process;

    public AbstractDeployment(Archive<?> archive) {
        this.archive = archive;
        this.containerConfig = KumuluzEEContainerConfig.getInstance();
        this.shouldDelete = this.containerConfig.shouldDeleteTemporaryFiles();
    }

    public void init() throws DeploymentException {
        try {
            Path tmpDirParent = Paths.get(System.getProperty("java.io.tmpdir"), TMP_DIR);
            Files.createDirectories(tmpDirParent, new FileAttribute[0]);
            this.chmod777(tmpDirParent.toFile());
            this.tmpDir = Files.createTempDirectory(tmpDirParent, null, new FileAttribute[0]);
            this.chmod777(this.tmpDir.toFile());
            if (this.shouldDelete) {
                this.tmpDir.toFile().deleteOnExit();
            }
        }
        catch (IOException e) {
            throw new DeploymentException("Could not create temporary folder", (Throwable)e);
        }
        this.exportArchive();
    }

    protected abstract void exportArchive() throws DeploymentException;

    protected abstract List<String> createArguments();

    public HTTPContext start() throws DeploymentException {
        Path javaPath;
        ArrayList<String> arguments = new ArrayList<String>();
        if (!this.containerConfig.getJavaPath().equals("")) {
            javaPath = Paths.get(this.containerConfig.getJavaPath(), new String[0]);
            if (!javaPath.toFile().exists()) {
                throw new DeploymentException("Specified java binary " + this.containerConfig.getJavaPath() + " could not be found.");
            }
        } else {
            javaPath = AbstractDeployment.javaPath();
        }
        arguments.add(javaPath.toString());
        if (!this.containerConfig.getJavaArguments().trim().isEmpty()) {
            arguments.addAll(Arrays.asList(this.containerConfig.getJavaArguments().trim().split(" ")));
        }
        arguments.addAll(this.createArguments());
        try {
            boolean isReady;
            LOG.fine("Starting process. Working directory: " + this.tmpDir.toString() + ". Command: " + String.join((CharSequence)" ", arguments));
            this.process = new ProcessBuilder(new String[0]).directory(this.tmpDir.toFile()).command(arguments).start();
            CountDownLatch serverReady = new CountDownLatch(1);
            OutputProcessor stdoutProcessor = new OutputProcessor(this.process.getInputStream(), serverReady);
            OutputProcessor stderrProcessor = new OutputProcessor(this.process.getErrorStream(), serverReady);
            Thread outThread = new Thread(stdoutProcessor);
            Thread errThread = new Thread(stderrProcessor);
            outThread.start();
            errThread.start();
            try {
                isReady = serverReady.await(this.containerConfig.getContainerStartTimeoutMs(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                isReady = false;
            }
            if (!isReady) {
                throw new DeploymentException("Deployment failed to start in time");
            }
            if (stdoutProcessor.getProcessingError() != null) {
                throw new DeploymentException("Error while processing server stdout", stdoutProcessor.getProcessingError());
            }
            if (stderrProcessor.getProcessingError() != null) {
                throw new DeploymentException("Error while processing server stderr", stderrProcessor.getProcessingError());
            }
            if (stdoutProcessor.getDeploymentError() != null) {
                throw new DeploymentException("Exception thrown during deployment", stdoutProcessor.getDeploymentError());
            }
            HTTPContext context = stdoutProcessor.getHttpContext();
            if (context == null) {
                throw new DeploymentException("Could not retrieve HTTP context from server");
            }
            LOG.fine("Deployment started, context: " + context.toString());
            return context;
        }
        catch (IOException e) {
            throw new DeploymentException("Could not start deployment", (Throwable)e);
        }
    }

    public void stop() {
        if (this.process != null) {
            this.process.destroy();
        }
        if (this.shouldDelete && this.tmpDir.toFile().exists()) {
            AbstractDeployment.deleteDirectory(this.tmpDir.toFile());
        }
    }

    protected void chmod777(File file) {
        file.setReadable(true, false);
        file.setWritable(true, false);
        file.setExecutable(true, false);
    }

    private static void deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                AbstractDeployment.deleteDirectory(file);
            }
        }
        directoryToBeDeleted.delete();
    }

    private static Path javaPath() throws DeploymentException {
        String javaHome = System.getProperty("java.home");
        if (javaHome == null) {
            throw new DeploymentException("Unable to locate java binary");
        }
        Path binDir = FileSystems.getDefault().getPath(javaHome, "bin");
        Path java = binDir.resolve("java.exe");
        if (java.toFile().exists()) {
            return java;
        }
        java = binDir.resolve("java");
        if (java.toFile().exists()) {
            return java;
        }
        throw new DeploymentException("Unable to locate java binary");
    }
}

