/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.testing.arquillian.deployment;

import com.kumuluz.ee.testing.arquillian.deployment.AbstractDeployment;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;

public class UberJarDeployment
extends AbstractDeployment {
    private static final String JAR_SUFFIX = ".jar";
    private File archiveFile;

    public UberJarDeployment(Archive<?> archive) {
        super(archive);
    }

    @Override
    protected void exportArchive() throws DeploymentException {
        try {
            this.archiveFile = Files.createTempFile(this.tmpDir, null, JAR_SUFFIX, new FileAttribute[0]).toFile();
            this.chmod777(this.archiveFile);
            if (this.shouldDelete) {
                this.archiveFile.deleteOnExit();
            }
            ((ZipExporter)this.archive.as(ZipExporter.class)).exportTo(this.archiveFile, true);
        }
        catch (IOException e) {
            throw new DeploymentException("Could not initialize deployment", (Throwable)e);
        }
    }

    @Override
    protected List<String> createArguments() {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-jar");
        arguments.add(this.archiveFile.getPath());
        return arguments;
    }
}

