/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.testing.arquillian.spi;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.resolver.api.maven.ConfigurableMavenResolverSystem;

public interface MavenDependencyAppender {
    default public ConfigurableMavenResolverSystem configureResolver(ConfigurableMavenResolverSystem resolver) {
        return resolver;
    }

    public List<String> addLibraries();

    public static List<String> getDeclaredLibraries() {
        Logger LOG = Logger.getLogger(MavenDependencyAppender.class.getName());
        ArrayList<String> libraries = new ArrayList<String>();
        ServiceLoader.load(MavenDependencyAppender.class).forEach(mda -> {
            LOG.fine("Adding libraries from " + mda.getClass().getSimpleName());
            libraries.addAll(mda.addLibraries());
        });
        return libraries;
    }

    public static ConfigurableMavenResolverSystem runResolverConfigurations(ConfigurableMavenResolverSystem resolver) {
        Logger LOG = Logger.getLogger(MavenDependencyAppender.class.getName());
        for (MavenDependencyAppender mda : ServiceLoader.load(MavenDependencyAppender.class)) {
            LOG.fine("Configuring resolver with " + mda.getClass().getSimpleName());
            resolver = mda.configureResolver(resolver);
        }
        return resolver;
    }
}

