/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.testing.arquillian.utils;

import com.kumuluz.ee.testing.arquillian.assets.MainWrapper;
import com.kumuluz.ee.testing.arquillian.assets.ServletWebListener;
import com.kumuluz.ee.testing.arquillian.utils.RequiredLibraries;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.ArchiveAsset;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.asset.ClassAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.asset.AssetUtil;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;

public class ArchiveUtils {
    private static final Logger LOG = Logger.getLogger(ArchiveUtils.class.getName());
    private static final Class<?>[] rootClasses = new Class[]{MainWrapper.class, ServletWebListener.class};

    private static JavaArchive generateWar(Archive<?> archive, List<String> deploymentLibraries) {
        JavaArchive javaArchive = (JavaArchive)archive.as(JavaArchive.class);
        Archive<?>[] requiredLibraries = RequiredLibraries.getRequiredLibraries(deploymentLibraries);
        Arrays.stream(requiredLibraries).forEach(f -> {
            JavaArchive cfr_ignored_0 = (JavaArchive)javaArchive.add((Asset)new ArchiveAsset(f, ZipExporter.class), "/WEB-INF/lib/" + f.getName());
        });
        return javaArchive;
    }

    public static JavaArchive generateUberJar(Archive<?> archive) {
        JavaArchive javaArchive = ArchiveUtils.generateWar(archive, Collections.singletonList("com.kumuluz.ee:kumuluzee-loader:"));
        ArchiveUtils.explodeAppArchiveToRoot(javaArchive);
        ArchiveUtils.explodeLoaderArchiveToRoot(javaArchive);
        ArchiveUtils.moveDir(javaArchive, "/WEB-INF/classes", "");
        ArchiveUtils.moveDir(javaArchive, "/WEB-INF/lib", "/lib");
        if (javaArchive.contains("/WEB-INF/beans.xml") && !javaArchive.contains("/META-INF/beans.xml")) {
            javaArchive.move("/WEB-INF/beans.xml", "/META-INF/beans.xml");
        }
        for (Class<?> klass : rootClasses) {
            javaArchive.addClass(klass);
        }
        javaArchive.addAsManifestResource("KumuluzEEManifest.MF", "MANIFEST.MF");
        javaArchive.addAsManifestResource((Asset)new StringAsset("main-class=" + MainWrapper.class.getName()), "kumuluzee/boot-loader.properties");
        return javaArchive;
    }

    public static JavaArchive generateExploded(Archive<?> archive) {
        JavaArchive javaArchive = ArchiveUtils.generateWar(archive, Collections.emptyList());
        ArchiveUtils.explodeAppArchiveToRoot(javaArchive);
        ArchiveUtils.fixArchiveAssets(javaArchive, "/WEB-INF/lib");
        ArrayList<String> dirsToMove = new ArrayList<String>();
        for (Node n : javaArchive.get("/").getChildren()) {
            if (n.getAsset() != null || n.getPath().get().endsWith("WEB-INF")) continue;
            dirsToMove.add(n.getPath().get());
        }
        for (String path : dirsToMove) {
            ArchiveUtils.moveDir(javaArchive, path, "/classes" + path);
        }
        ArchiveUtils.moveDir(javaArchive, "/WEB-INF/classes", "/classes");
        ArchiveUtils.moveDir(javaArchive, "/WEB-INF/lib", "/dependency");
        if (javaArchive.contains("/WEB-INF/beans.xml") && !javaArchive.contains("/classes/META-INF/beans.xml")) {
            javaArchive.move("/WEB-INF/beans.xml", "/classes/META-INF/beans.xml");
        }
        javaArchive.addAsDirectory("/classes/webapp");
        ArchiveUtils.moveDir(javaArchive, "/WEB-INF", "/classes/webapp/WEB-INF");
        for (Class<?> klass : rootClasses) {
            ClassAsset classAsset = new ClassAsset(klass);
            BasicPath classArchivePath = new BasicPath("/classes", AssetUtil.getFullPathForClassResource(klass));
            javaArchive.add((Asset)classAsset, (ArchivePath)classArchivePath);
        }
        return javaArchive;
    }

    private static void explodeAppArchiveToRoot(JavaArchive javaArchive) {
        for (Node n : javaArchive.get("/WEB-INF/lib").getChildren()) {
            Archive dependencyJar;
            if (!(n.getAsset() instanceof ArchiveAsset) || !(dependencyJar = ((ArchiveAsset)n.getAsset()).getArchive()).contains("/__kumuluzee_arquillian_marker__")) continue;
            LOG.fine("Found application archive: " + dependencyJar.getName());
            dependencyJar.delete("/__kumuluzee_arquillian_marker__");
            javaArchive.merge(dependencyJar);
            javaArchive.delete(n.getPath());
            break;
        }
    }

    private static void explodeLoaderArchiveToRoot(JavaArchive javaArchive) {
        for (Node n : javaArchive.get("/WEB-INF/lib").getChildren()) {
            if (!(n.getAsset() instanceof ArchiveAsset) || !((ArchiveAsset)n.getAsset()).getArchive().getName().startsWith("kumuluzee-loader-")) continue;
            Archive dependencyJar = ((ArchiveAsset)n.getAsset()).getArchive();
            LOG.fine("Found kumuluzee-loader archive: " + dependencyJar.getName());
            javaArchive.merge(dependencyJar);
            javaArchive.delete(n.getPath());
            break;
        }
    }

    private static void fixArchiveAssets(Archive<?> a, String parentDir) {
        Node n = a.get(parentDir);
        Archive tmp = (Archive)ShrinkWrap.create(JavaArchive.class);
        ArrayList<ArchivePath> pathsToDelete = new ArrayList<ArchivePath>();
        for (Node child : n.getChildren()) {
            Asset childAsset = child.getAsset();
            if (!(childAsset instanceof ArchiveAsset) || !child.getPath().get().endsWith(".jar")) continue;
            LOG.fine("Converting archive " + child.getPath().get() + " to ByteArrayAsset");
            ArchiveAsset archiveAsset = (ArchiveAsset)childAsset;
            ByteArrayAsset bas = new ByteArrayAsset(archiveAsset.openStream());
            pathsToDelete.add(child.getPath());
            tmp.add((Asset)bas, child.getPath());
        }
        for (ArchivePath ap : pathsToDelete) {
            a.delete(ap);
        }
        a.merge(tmp);
    }

    private static void moveDir(Archive<?> archive, String source, String target) {
        if (archive.contains(source)) {
            Archive tmp = (Archive)ShrinkWrap.create(JavaArchive.class);
            ArchiveUtils.copyDir(archive, tmp, source, target);
            archive.merge(tmp);
            archive.delete(source);
        }
    }

    private static void copyDir(Archive<?> sourceArchive, Archive<?> targetArchive, String source, String target) {
        Node sourceNode = sourceArchive.get(source);
        if (sourceNode.getAsset() != null) {
            targetArchive.add(sourceNode.getAsset(), target);
        } else {
            for (Node child : sourceNode.getChildren()) {
                String childName = child.getPath().get().replaceFirst(child.getPath().getParent().get(), "");
                ArchiveUtils.copyDir(sourceArchive, targetArchive, child.getPath().get(), ArchivePaths.create((String)target, (String)childName).get());
            }
        }
    }
}

