/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.testing.arquillian.utils;

import com.kumuluz.ee.testing.arquillian.exceptions.ParsingException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.util.Base64;
import java.util.concurrent.CountDownLatch;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;

public class OutputProcessor
implements Runnable,
Closeable {
    private InputStream stream;
    private CountDownLatch latch;
    private HTTPContext httpContext;
    private Throwable processingError;
    private Throwable deploymentError;

    public OutputProcessor(InputStream stream, CountDownLatch latch) {
        this.stream = stream;
        this.latch = latch;
    }

    public HTTPContext getHttpContext() {
        return this.httpContext;
    }

    public Throwable getProcessingError() {
        return this.processingError;
    }

    public Throwable getDeploymentError() {
        return this.deploymentError;
    }

    @Override
    public void run() {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.stream));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("KumuluzEE Arquillian: ")) {
                    this.processMessage(line.trim());
                    continue;
                }
                System.out.println(line);
            }
        }
        catch (ParsingException | IOException e) {
            this.processingError = e;
            this.latch.countDown();
        }
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    private void processMessage(String message) throws ParsingException {
        if (message.equals("KumuluzEE Arquillian: Server started")) {
            this.latch.countDown();
        } else if (message.startsWith("KumuluzEE Arquillian: HTTP Context: ")) {
            int port;
            String metadata = message.substring("KumuluzEE Arquillian: HTTP Context: ".length());
            String[] tokens = metadata.split("\t");
            try {
                port = Integer.parseInt(tokens[0]);
            }
            catch (IndexOutOfBoundsException | NumberFormatException e) {
                throw new ParsingException("Could not parse port from string: " + metadata, e);
            }
            this.httpContext = new HTTPContext("localhost", port);
            for (int i = 1; i < tokens.length; ++i) {
                if (tokens[i].isEmpty()) continue;
                String[] servletInfo = tokens[i].split(":");
                if (servletInfo.length < 1) {
                    throw new ParsingException("Could not parse servlet information from token: " + tokens[i]);
                }
                this.httpContext.add(new Servlet(servletInfo[0], servletInfo.length > 1 ? servletInfo[1] : ""));
            }
        } else if (message.startsWith("KumuluzEE Arquillian: Exception thrown: ")) {
            try {
                byte[] serialized = Base64.getDecoder().decode(message.substring("KumuluzEE Arquillian: Exception thrown: ".length()).getBytes());
                ByteArrayInputStream bi = new ByteArrayInputStream(serialized);
                ObjectInputStream si = new ObjectInputStream(bi);
                this.deploymentError = (Exception)si.readObject();
                this.latch.countDown();
            }
            catch (IOException | ClassNotFoundException e1) {
                throw new ParsingException("Error while deserializing exception.", e1);
            }
        } else {
            throw new ParsingException("Could not parse message: " + message);
        }
    }
}

