/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.testing.arquillian.utils;

import com.kumuluz.ee.testing.arquillian.KumuluzEEContainerConfig;
import com.kumuluz.ee.testing.arquillian.spi.MavenDependencyAppender;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.resolver.api.maven.ConfigurableMavenResolverSystem;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenRemoteRepositories;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenRemoteRepository;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenUpdatePolicy;

public class RequiredLibraries {
    private static final Logger LOG = Logger.getLogger(RequiredLibraries.class.getName());
    private static final String[] LIBS_DEFAULT = new String[]{"com.kumuluz.ee:kumuluzee-core:", "com.kumuluz.ee:kumuluzee-servlet-jetty:", "com.kumuluz.ee:kumuluzee-cdi-weld:"};
    private static final String[] LIBS_MP1_0 = new String[]{"com.kumuluz.ee:kumuluzee-microProfile-1.0:"};
    private static final String[] LIBS_MP1_1 = new String[]{"com.kumuluz.ee:kumuluzee-microProfile-1.1:"};
    private static final String[] LIBS_MP1_2 = new String[]{"com.kumuluz.ee:kumuluzee-microProfile-1.2:"};

    public static Archive<?>[] getRequiredLibraries(List<String> deploymentLibs) {
        Archive[] resolvedLibs;
        List<String> libraries = MavenDependencyAppender.getDeclaredLibraries();
        libraries.addAll(deploymentLibs);
        KumuluzEEContainerConfig config = KumuluzEEContainerConfig.getInstance();
        String kumuluzVersion = config.getKumuluzVersion();
        List<String> includedLibs = RequiredLibraries.getIncludedLibraries(config.getIncludeRequiredLibraries());
        LOG.fine("Adding libraries based on the includeRequiredLibraries config parameter (value: " + config.getIncludeRequiredLibraries() + "): " + String.join((CharSequence)", ", includedLibs));
        libraries.addAll(includedLibs);
        libraries = libraries.stream().map(s -> s.endsWith(":") ? s + kumuluzVersion : s).collect(Collectors.toList());
        ConfigurableMavenResolverSystem resolver = Maven.configureResolver();
        if (kumuluzVersion.contains("SNAPSHOT")) {
            LOG.fine("KumuluzEE version is snapshot, adding snapshot repository to Maven resolver");
            MavenRemoteRepository sonatypeSnapshots = MavenRemoteRepositories.createRemoteRepository((String)"sonatype-snapshots", (String)"https://oss.sonatype.org/content/repositories/snapshots", (String)"default");
            sonatypeSnapshots.setUpdatePolicy(MavenUpdatePolicy.UPDATE_POLICY_DAILY);
            resolver = (ConfigurableMavenResolverSystem)resolver.withRemoteRepo(sonatypeSnapshots);
        }
        resolver = MavenDependencyAppender.runResolverConfigurations(resolver);
        Archive[] archiveArray = resolvedLibs = libraries.isEmpty() ? new Archive[]{} : (Archive[])((MavenFormatStage)((MavenStrategyStage)resolver.resolve(libraries)).withTransitivity()).as(JavaArchive.class);
        if (config.getIncludeRequiredLibraries().equals("fromPom")) {
            LOG.fine("Resolving compile, runtime and test dependencies from pom.xml");
            Archive[] pomLibs = (Archive[])((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)((PomEquippedResolveStage)((PomEquippedResolveStage)resolver.loadPomFromFile("pom.xml")).importCompileAndRuntimeDependencies()).importTestDependencies()).resolve()).withTransitivity()).as(JavaArchive.class);
            resolvedLibs = (Archive[])Stream.concat(Arrays.stream(resolvedLibs), Arrays.stream(pomLibs)).toArray(Archive[]::new);
        }
        return resolvedLibs;
    }

    private static List<String> getIncludedLibraries(String includeRequiredLibraries) {
        switch (includeRequiredLibraries) {
            case "false": 
            case "fromPom": {
                return Collections.emptyList();
            }
            case "default": {
                return Arrays.asList(LIBS_DEFAULT);
            }
            case "MicroProfile-1.0": {
                return Arrays.asList(LIBS_MP1_0);
            }
            case "MicroProfile-1.1": {
                return Arrays.asList(LIBS_MP1_1);
            }
            case "MicroProfile-1.2": {
                return Arrays.asList(LIBS_MP1_2);
            }
        }
        throw new RuntimeException("Could not determine includeRequiredLibraries parameter: " + includeRequiredLibraries);
    }
}

