/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.com.launchdarkly.sdk.internal.events;

import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.shaded.org.jetbrains.annotations.NotNull;
import com.launchdarkly.shaded.org.jetbrains.annotations.Nullable;

public class Event {
    private final long creationDate;
    private final LDContext context;

    public Event(long creationDate, LDContext context) {
        this.creationDate = creationDate;
        this.context = context;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public LDContext getContext() {
        return this.context;
    }

    public long getSamplingRatio() {
        return 1L;
    }

    public static final class MigrationOp
    extends Event {
        private final String featureKey;
        private final int variation;
        private final LDValue value;
        private final LDValue defaultVal;
        private final EvaluationReason reason;
        private final long samplingRatio;
        private final String operation;
        private final int flagVersion;
        private final ConsistencyMeasurement consistencyMeasurement;
        private final LatencyMeasurement latencyMeasurement;
        private final ErrorMeasurement errorMeasurement;
        private final InvokedMeasurement invokedMeasurement;

        public MigrationOp(long timestamp, @NotNull LDContext context, @NotNull String featureKey, int variation, int flagVersion, @NotNull LDValue value, @NotNull LDValue defaultVal, @Nullable EvaluationReason reason, long samplingRatio, @NotNull String operation, @NotNull InvokedMeasurement invokedMeasurement, @Nullable ConsistencyMeasurement consistencyMeasurement, @Nullable LatencyMeasurement latencyMeasurement, @Nullable ErrorMeasurement errorMeasurement) {
            super(timestamp, context);
            this.featureKey = featureKey;
            this.variation = variation;
            this.flagVersion = flagVersion;
            this.value = value;
            this.defaultVal = defaultVal;
            this.reason = reason;
            this.samplingRatio = samplingRatio;
            this.operation = operation;
            this.consistencyMeasurement = consistencyMeasurement;
            this.latencyMeasurement = latencyMeasurement;
            this.errorMeasurement = errorMeasurement;
            this.invokedMeasurement = invokedMeasurement;
        }

        @NotNull
        public String getFeatureKey() {
            return this.featureKey;
        }

        public int getVariation() {
            return this.variation;
        }

        public int getFlagVersion() {
            return this.flagVersion;
        }

        @NotNull
        public LDValue getValue() {
            return this.value;
        }

        @NotNull
        public LDValue getDefaultVal() {
            return this.defaultVal;
        }

        @Nullable
        public EvaluationReason getReason() {
            return this.reason;
        }

        @NotNull
        public InvokedMeasurement getInvokedMeasurement() {
            return this.invokedMeasurement;
        }

        @Nullable
        public LatencyMeasurement getLatencyMeasurement() {
            return this.latencyMeasurement;
        }

        @Nullable
        public ErrorMeasurement getErrorMeasurement() {
            return this.errorMeasurement;
        }

        @Nullable
        public ConsistencyMeasurement getConsistencyMeasurement() {
            return this.consistencyMeasurement;
        }

        @Override
        public long getSamplingRatio() {
            return this.samplingRatio;
        }

        public String getOperation() {
            return this.operation;
        }

        public static final class InvokedMeasurement {
            private final boolean oldInvoked;
            private final boolean newInvoked;

            public InvokedMeasurement(boolean oldInvoked, boolean newInvoked) {
                this.oldInvoked = oldInvoked;
                this.newInvoked = newInvoked;
            }

            public boolean wasOldInvoked() {
                return this.oldInvoked;
            }

            public boolean wasNewInvoked() {
                return this.newInvoked;
            }
        }

        public static final class ErrorMeasurement {
            private final boolean oldError;
            private final boolean newError;

            public ErrorMeasurement(boolean oldError, boolean newError) {
                this.oldError = oldError;
                this.newError = newError;
            }

            public boolean hasOldError() {
                return this.oldError;
            }

            public boolean hasNewError() {
                return this.newError;
            }

            public boolean hasMeasurement() {
                return this.oldError || this.newError;
            }
        }

        public static final class LatencyMeasurement {
            private final Long oldLatencyMs;
            private final Long newLatencyMs;

            public LatencyMeasurement(@Nullable Long oldLatency, @Nullable Long newLatency) {
                this.oldLatencyMs = oldLatency;
                this.newLatencyMs = newLatency;
            }

            public Long getOldLatencyMs() {
                return this.oldLatencyMs;
            }

            public Long getNewLatencyMs() {
                return this.newLatencyMs;
            }

            public boolean hasMeasurement() {
                return this.oldLatencyMs != null || this.newLatencyMs != null;
            }
        }

        public static final class ConsistencyMeasurement {
            private final boolean consistent;
            private final long samplingRatio;

            public ConsistencyMeasurement(boolean consistent, long samplingRatio) {
                this.consistent = consistent;
                this.samplingRatio = samplingRatio;
            }

            public boolean isConsistent() {
                return this.consistent;
            }

            public long getSamplingRatio() {
                return this.samplingRatio;
            }
        }
    }

    public static final class FeatureRequest
    extends Event {
        private final String key;
        private final int variation;
        private final LDValue value;
        private final LDValue defaultVal;
        private final int version;
        private final String prereqOf;
        private final boolean trackEvents;
        private final Long debugEventsUntilDate;
        private final EvaluationReason reason;
        private final boolean debug;
        private final long samplingRatio;
        private final boolean excludeFromSummaries;

        public FeatureRequest(long timestamp, String key, LDContext context, int version, int variation, LDValue value, LDValue defaultVal, EvaluationReason reason, String prereqOf, boolean trackEvents, Long debugEventsUntilDate, boolean debug, long samplingRatio, boolean excludeFromSummaries) {
            super(timestamp, context);
            this.key = key;
            this.version = version;
            this.variation = variation;
            this.value = value;
            this.defaultVal = defaultVal;
            this.prereqOf = prereqOf;
            this.trackEvents = trackEvents;
            this.debugEventsUntilDate = debugEventsUntilDate;
            this.reason = reason;
            this.debug = debug;
            this.excludeFromSummaries = excludeFromSummaries;
            this.samplingRatio = samplingRatio;
        }

        public FeatureRequest(long timestamp, String key, LDContext context, int version, int variation, LDValue value, LDValue defaultVal, EvaluationReason reason, String prereqOf, boolean trackEvents, Long debugEventsUntilDate, boolean debug) {
            this(timestamp, key, context, version, variation, value, defaultVal, reason, prereqOf, trackEvents, debugEventsUntilDate, debug, 1L, false);
        }

        public String getKey() {
            return this.key;
        }

        public int getVariation() {
            return this.variation;
        }

        public LDValue getValue() {
            return this.value;
        }

        public LDValue getDefaultVal() {
            return this.defaultVal;
        }

        public int getVersion() {
            return this.version;
        }

        public String getPrereqOf() {
            return this.prereqOf;
        }

        public boolean isTrackEvents() {
            return this.trackEvents;
        }

        public Long getDebugEventsUntilDate() {
            return this.debugEventsUntilDate;
        }

        public EvaluationReason getReason() {
            return this.reason;
        }

        public boolean isDebug() {
            return this.debug;
        }

        public boolean isExcludeFromSummaries() {
            return this.excludeFromSummaries;
        }

        @Override
        public long getSamplingRatio() {
            return this.samplingRatio;
        }

        public FeatureRequest toDebugEvent() {
            return new FeatureRequest(this.getCreationDate(), this.getKey(), this.getContext(), this.getVersion(), this.getVariation(), this.getValue(), this.getDefaultVal(), this.getReason(), this.getPrereqOf(), false, null, true, this.samplingRatio, this.excludeFromSummaries);
        }
    }

    public static final class Index
    extends Event {
        public Index(long timestamp, LDContext context) {
            super(timestamp, context);
        }
    }

    public static final class Identify
    extends Event {
        public Identify(long timestamp, LDContext context) {
            super(timestamp, context);
        }
    }

    public static final class Custom
    extends Event {
        private final String key;
        private final LDValue data;
        private final Double metricValue;

        public Custom(long timestamp, String key, LDContext context, LDValue data, Double metricValue) {
            super(timestamp, context);
            this.key = key;
            this.data = LDValue.normalize(data);
            this.metricValue = metricValue;
        }

        public String getKey() {
            return this.key;
        }

        public LDValue getData() {
            return this.data;
        }

        public Double getMetricValue() {
            return this.metricValue;
        }
    }
}

