/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk;

import com.launchdarkly.sdk.EvaluationReasonTypeAdapter;
import com.launchdarkly.sdk.json.JsonSerializable;
import com.launchdarkly.shaded.com.google.gson.annotations.JsonAdapter;
import java.util.Objects;

@JsonAdapter(value=EvaluationReasonTypeAdapter.class)
public final class EvaluationReason
implements JsonSerializable {
    private static boolean IN_EXPERIMENT = true;
    private static boolean NOT_IN_EXPERIMENT = false;
    private static final EvaluationReason OFF_INSTANCE = new EvaluationReason(Kind.OFF);
    private static final EvaluationReason FALLTHROUGH_INSTANCE = new EvaluationReason(Kind.FALLTHROUGH);
    private static final EvaluationReason FALLTHROUGH_INSTANCE_IN_EXPERIMENT = new EvaluationReason(Kind.FALLTHROUGH, IN_EXPERIMENT);
    private static final EvaluationReason TARGET_MATCH_INSTANCE = new EvaluationReason(Kind.TARGET_MATCH);
    private static final EvaluationReason ERROR_CLIENT_NOT_READY = new EvaluationReason(ErrorKind.CLIENT_NOT_READY, null);
    private static final EvaluationReason ERROR_FLAG_NOT_FOUND = new EvaluationReason(ErrorKind.FLAG_NOT_FOUND, null);
    private static final EvaluationReason ERROR_MALFORMED_FLAG = new EvaluationReason(ErrorKind.MALFORMED_FLAG, null);
    private static final EvaluationReason ERROR_USER_NOT_SPECIFIED = new EvaluationReason(ErrorKind.USER_NOT_SPECIFIED, null);
    private static final EvaluationReason ERROR_WRONG_TYPE = new EvaluationReason(ErrorKind.WRONG_TYPE, null);
    private static final EvaluationReason ERROR_EXCEPTION = new EvaluationReason(ErrorKind.EXCEPTION, null);
    private final Kind kind;
    private final int ruleIndex;
    private final String ruleId;
    private final String prerequisiteKey;
    private final boolean inExperiment;
    private final ErrorKind errorKind;
    private final Exception exception;
    private final BigSegmentsStatus bigSegmentsStatus;

    private EvaluationReason(Kind kind, int ruleIndex, String ruleId, String prerequisiteKey, boolean inExperiment, ErrorKind errorKind, Exception exception, BigSegmentsStatus bigSegmentsStatus) {
        this.kind = kind;
        this.ruleIndex = ruleIndex;
        this.ruleId = ruleId;
        this.prerequisiteKey = prerequisiteKey;
        this.inExperiment = inExperiment;
        this.errorKind = errorKind;
        this.exception = exception;
        this.bigSegmentsStatus = bigSegmentsStatus;
    }

    private EvaluationReason(Kind kind) {
        this(kind, -1, null, null, NOT_IN_EXPERIMENT, null, null, null);
    }

    private EvaluationReason(Kind kind, boolean inExperiment) {
        this(kind, -1, null, null, inExperiment, null, null, null);
    }

    private EvaluationReason(ErrorKind errorKind, Exception exception) {
        this(Kind.ERROR, -1, null, null, NOT_IN_EXPERIMENT, errorKind, exception, null);
    }

    public Kind getKind() {
        return this.kind;
    }

    public int getRuleIndex() {
        return this.ruleIndex;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public String getPrerequisiteKey() {
        return this.prerequisiteKey;
    }

    public boolean isInExperiment() {
        return this.inExperiment;
    }

    public ErrorKind getErrorKind() {
        return this.errorKind;
    }

    public Exception getException() {
        return this.exception;
    }

    public BigSegmentsStatus getBigSegmentsStatus() {
        return this.bigSegmentsStatus;
    }

    public EvaluationReason withBigSegmentsStatus(BigSegmentsStatus bigSegmentsStatus) {
        return new EvaluationReason(this.kind, this.ruleIndex, this.ruleId, this.prerequisiteKey, this.inExperiment, this.errorKind, this.exception, bigSegmentsStatus);
    }

    public String toString() {
        switch (this.kind) {
            case RULE_MATCH: {
                return (Object)((Object)this.kind) + "(" + this.ruleIndex + (this.ruleId == null ? "" : "," + this.ruleId) + ")";
            }
            case PREREQUISITE_FAILED: {
                return (Object)((Object)this.kind) + "(" + this.prerequisiteKey + ")";
            }
            case ERROR: {
                return (Object)((Object)this.kind) + "(" + (Object)((Object)this.errorKind) + (this.exception == null ? "" : "," + this.exception) + ")";
            }
        }
        return this.getKind().name();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof EvaluationReason) {
            EvaluationReason o = (EvaluationReason)other;
            return this.kind == o.kind && this.ruleIndex == o.ruleIndex && Objects.equals(this.ruleId, o.ruleId) && Objects.equals(this.prerequisiteKey, o.prerequisiteKey) && this.inExperiment == o.inExperiment && Objects.equals((Object)this.errorKind, (Object)o.errorKind) && Objects.equals(this.exception, o.exception) && Objects.equals((Object)this.bigSegmentsStatus, (Object)o.bigSegmentsStatus);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.ruleIndex, this.ruleId, this.prerequisiteKey, this.inExperiment, this.errorKind, this.exception, this.bigSegmentsStatus});
    }

    public static EvaluationReason off() {
        return OFF_INSTANCE;
    }

    public static EvaluationReason fallthrough() {
        return FALLTHROUGH_INSTANCE;
    }

    public static EvaluationReason fallthrough(boolean inExperiment) {
        return inExperiment ? FALLTHROUGH_INSTANCE_IN_EXPERIMENT : FALLTHROUGH_INSTANCE;
    }

    public static EvaluationReason targetMatch() {
        return TARGET_MATCH_INSTANCE;
    }

    public static EvaluationReason ruleMatch(int ruleIndex, String ruleId) {
        return EvaluationReason.ruleMatch(ruleIndex, ruleId, NOT_IN_EXPERIMENT);
    }

    public static EvaluationReason ruleMatch(int ruleIndex, String ruleId, boolean inExperiment) {
        return new EvaluationReason(Kind.RULE_MATCH, ruleIndex, ruleId, null, inExperiment, null, null, null);
    }

    public static EvaluationReason prerequisiteFailed(String prerequisiteKey) {
        return new EvaluationReason(Kind.PREREQUISITE_FAILED, -1, null, prerequisiteKey, NOT_IN_EXPERIMENT, null, null, null);
    }

    public static EvaluationReason error(ErrorKind errorKind) {
        switch (errorKind) {
            case CLIENT_NOT_READY: {
                return ERROR_CLIENT_NOT_READY;
            }
            case EXCEPTION: {
                return ERROR_EXCEPTION;
            }
            case FLAG_NOT_FOUND: {
                return ERROR_FLAG_NOT_FOUND;
            }
            case MALFORMED_FLAG: {
                return ERROR_MALFORMED_FLAG;
            }
            case USER_NOT_SPECIFIED: {
                return ERROR_USER_NOT_SPECIFIED;
            }
            case WRONG_TYPE: {
                return ERROR_WRONG_TYPE;
            }
        }
        return new EvaluationReason(errorKind, null);
    }

    public static EvaluationReason exception(Exception exception) {
        return new EvaluationReason(ErrorKind.EXCEPTION, exception);
    }

    public static enum BigSegmentsStatus {
        HEALTHY,
        STALE,
        NOT_CONFIGURED,
        STORE_ERROR;

    }

    public static enum ErrorKind {
        CLIENT_NOT_READY,
        FLAG_NOT_FOUND,
        MALFORMED_FLAG,
        USER_NOT_SPECIFIED,
        WRONG_TYPE,
        EXCEPTION;

    }

    public static enum Kind {
        OFF,
        FALLTHROUGH,
        TARGET_MATCH,
        RULE_MATCH,
        PREREQUISITE_FAILED,
        ERROR;

    }
}

