/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.LDValueType;
import com.launchdarkly.sdk.server.EvalResultAndFlag;
import com.launchdarkly.sdk.server.EvaluationOptions;
import com.launchdarkly.sdk.server.EvaluatorInterface;
import com.launchdarkly.sdk.server.FeatureFlagsState;
import com.launchdarkly.sdk.server.FlagsStateOption;
import com.launchdarkly.sdk.server.integrations.EvaluationSeriesContext;
import com.launchdarkly.sdk.server.integrations.Hook;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class EvaluatorWithHooks
implements EvaluatorInterface {
    private final EvaluatorInterface underlyingEvaluator;
    private final List<Hook> hooks;
    private final LDLogger logger;

    EvaluatorWithHooks(EvaluatorInterface underlyingEvaluator, List<Hook> hooks, LDLogger hooksLogger) {
        this.underlyingEvaluator = underlyingEvaluator;
        this.hooks = hooks;
        this.logger = hooksLogger;
    }

    @Override
    public EvalResultAndFlag evalAndFlag(String method, String featureKey, LDContext context, LDValue defaultValue, LDValueType requireType, EvaluationOptions options) {
        int size = this.hooks.size();
        ArrayList<Map<String, Object>> seriesDataList = new ArrayList<Map<String, Object>>(size);
        EvaluationSeriesContext seriesContext = new EvaluationSeriesContext(method, featureKey, context, defaultValue);
        Map<String, Object> emptyMap = Collections.emptyMap();
        for (int i = 0; i < size; ++i) {
            Hook currentHook = this.hooks.get(i);
            try {
                Map<String, Object> seriesData = currentHook.beforeEvaluation(seriesContext, emptyMap);
                seriesDataList.add(seriesData.isEmpty() ? emptyMap : Collections.unmodifiableMap(seriesData));
                continue;
            }
            catch (Exception e) {
                seriesDataList.add(emptyMap);
                this.logger.error("During evaluation of flag \"{}\". Stage \"BeforeEvaluation\" of hook \"{}\" reported error: {}", featureKey, currentHook.getMetadata().getName(), e.toString());
            }
        }
        EvalResultAndFlag result = this.underlyingEvaluator.evalAndFlag(method, featureKey, context, defaultValue, requireType, options);
        for (int i = size - 1; i >= 0; --i) {
            Hook currentHook = this.hooks.get(i);
            try {
                currentHook.afterEvaluation(seriesContext, (Map)seriesDataList.get(i), result.getResult().getAnyType());
                continue;
            }
            catch (Exception e) {
                this.logger.error("During evaluation of flag \"{}\". Stage \"AfterEvaluation\" of hook \"{}\" reported error: {}", featureKey, currentHook.getMetadata().getName(), e.toString());
            }
        }
        return result;
    }

    @Override
    public FeatureFlagsState allFlagsState(LDContext context, FlagsStateOption ... options) {
        return this.underlyingEvaluator.allFlagsState(context, options);
    }
}

