/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.ComponentsImpl;
import com.launchdarkly.sdk.server.integrations.ApplicationInfoBuilder;
import com.launchdarkly.sdk.server.integrations.HooksConfigurationBuilder;
import com.launchdarkly.sdk.server.integrations.PluginsConfigurationBuilder;
import com.launchdarkly.sdk.server.integrations.ServiceEndpointsBuilder;
import com.launchdarkly.sdk.server.integrations.WrapperInfoBuilder;
import com.launchdarkly.sdk.server.interfaces.ApplicationInfo;
import com.launchdarkly.sdk.server.interfaces.BigSegmentsConfiguration;
import com.launchdarkly.sdk.server.interfaces.ServiceEndpoints;
import com.launchdarkly.sdk.server.interfaces.WrapperInfo;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import com.launchdarkly.sdk.server.subsystems.DataSource;
import com.launchdarkly.sdk.server.subsystems.DataStore;
import com.launchdarkly.sdk.server.subsystems.EventProcessor;
import com.launchdarkly.sdk.server.subsystems.HookConfiguration;
import com.launchdarkly.sdk.server.subsystems.HttpConfiguration;
import com.launchdarkly.sdk.server.subsystems.LoggingConfiguration;
import com.launchdarkly.sdk.server.subsystems.PluginsConfiguration;
import java.time.Duration;

public final class LDConfig {
    public static final Duration DEFAULT_START_WAIT = Duration.ofSeconds(5L);
    protected static final LDConfig DEFAULT = new Builder().build();
    final ApplicationInfo applicationInfo;
    final ComponentConfigurer<BigSegmentsConfiguration> bigSegments;
    final ComponentConfigurer<DataSource> dataSource;
    final ComponentConfigurer<DataStore> dataStore;
    final boolean diagnosticOptOut;
    final ComponentConfigurer<EventProcessor> events;
    final HookConfiguration hooks;
    final PluginsConfiguration plugins;
    final ComponentConfigurer<HttpConfiguration> http;
    final ComponentConfigurer<LoggingConfiguration> logging;
    final ServiceEndpoints serviceEndpoints;
    final boolean offline;
    final Duration startWait;
    final int threadPriority;
    final WrapperInfo wrapperInfo;

    protected LDConfig(Builder builder) {
        if (builder.offline) {
            this.dataSource = Components.externalUpdatesOnly();
            this.events = Components.noEvents();
        } else {
            this.dataSource = builder.dataSource == null ? Components.streamingDataSource() : builder.dataSource;
            this.events = builder.events == null ? Components.sendEvents() : builder.events;
        }
        this.applicationInfo = (builder.applicationInfoBuilder == null ? Components.applicationInfo() : builder.applicationInfoBuilder).createApplicationInfo();
        this.bigSegments = builder.bigSegments == null ? Components.bigSegments(null) : builder.bigSegments;
        this.dataStore = builder.dataStore == null ? Components.inMemoryDataStore() : builder.dataStore;
        this.diagnosticOptOut = builder.diagnosticOptOut;
        this.hooks = (builder.hooksConfigurationBuilder == null ? Components.hooks() : builder.hooksConfigurationBuilder).build();
        this.plugins = (builder.pluginsConfigurationBuilder == null ? Components.plugins() : builder.pluginsConfigurationBuilder).build();
        this.http = builder.http == null ? Components.httpConfiguration() : builder.http;
        this.logging = builder.logging == null ? Components.logging() : builder.logging;
        this.offline = builder.offline;
        this.serviceEndpoints = (builder.serviceEndpointsBuilder == null ? Components.serviceEndpoints() : builder.serviceEndpointsBuilder).createServiceEndpoints();
        this.startWait = builder.startWait;
        this.threadPriority = builder.threadPriority;
        this.wrapperInfo = builder.wrapperBuilder != null ? builder.wrapperBuilder.build() : null;
    }

    public static class Builder {
        private ApplicationInfoBuilder applicationInfoBuilder = null;
        private ComponentConfigurer<BigSegmentsConfiguration> bigSegments = null;
        private ComponentConfigurer<DataSource> dataSource = null;
        private ComponentConfigurer<DataStore> dataStore = null;
        private boolean diagnosticOptOut = false;
        private ComponentConfigurer<EventProcessor> events = null;
        private HooksConfigurationBuilder hooksConfigurationBuilder = null;
        private PluginsConfigurationBuilder pluginsConfigurationBuilder = null;
        private ComponentConfigurer<HttpConfiguration> http = null;
        private ComponentConfigurer<LoggingConfiguration> logging = null;
        private ServiceEndpointsBuilder serviceEndpointsBuilder = null;
        private boolean offline = false;
        private Duration startWait = DEFAULT_START_WAIT;
        private int threadPriority = 1;
        private WrapperInfoBuilder wrapperBuilder = null;

        public static Builder fromConfig(LDConfig config) {
            Builder newBuilder = new Builder();
            newBuilder.applicationInfoBuilder = ApplicationInfoBuilder.fromApplicationInfo(config.applicationInfo);
            newBuilder.bigSegments = config.bigSegments;
            newBuilder.dataSource = config.dataSource;
            newBuilder.dataStore = config.dataStore;
            newBuilder.diagnosticOptOut = config.diagnosticOptOut;
            newBuilder.events = config.events;
            newBuilder.hooksConfigurationBuilder = ComponentsImpl.HooksConfigurationBuilderImpl.fromHooksConfiguration(config.hooks);
            newBuilder.pluginsConfigurationBuilder = ComponentsImpl.PluginsConfigurationBuilderImpl.fromPluginsConfiguration(config.plugins);
            newBuilder.http = config.http;
            newBuilder.logging = config.logging;
            newBuilder.serviceEndpointsBuilder = ComponentsImpl.ServiceEndpointsBuilderImpl.fromServiceEndpoints(config.serviceEndpoints);
            newBuilder.offline = config.offline;
            newBuilder.startWait = config.startWait;
            newBuilder.threadPriority = config.threadPriority;
            newBuilder.wrapperBuilder = config.wrapperInfo != null ? ComponentsImpl.WrapperInfoBuilderImpl.fromInfo(config.wrapperInfo) : null;
            return newBuilder;
        }

        public Builder applicationInfo(ApplicationInfoBuilder applicationInfoBuilder) {
            this.applicationInfoBuilder = applicationInfoBuilder;
            return this;
        }

        public Builder bigSegments(ComponentConfigurer<BigSegmentsConfiguration> bigSegmentsConfigurer) {
            this.bigSegments = bigSegmentsConfigurer;
            return this;
        }

        public Builder dataSource(ComponentConfigurer<DataSource> dataSourceConfigurer) {
            this.dataSource = dataSourceConfigurer;
            return this;
        }

        public Builder dataStore(ComponentConfigurer<DataStore> dataStoreConfigurer) {
            this.dataStore = dataStoreConfigurer;
            return this;
        }

        public Builder diagnosticOptOut(boolean diagnosticOptOut) {
            this.diagnosticOptOut = diagnosticOptOut;
            return this;
        }

        public Builder events(ComponentConfigurer<EventProcessor> eventsConfigurer) {
            this.events = eventsConfigurer;
            return this;
        }

        public Builder hooks(HooksConfigurationBuilder hooksConfiguration) {
            this.hooksConfigurationBuilder = hooksConfiguration;
            return this;
        }

        public Builder plugins(PluginsConfigurationBuilder pluginsConfiguration) {
            this.pluginsConfigurationBuilder = pluginsConfiguration;
            return this;
        }

        public Builder http(ComponentConfigurer<HttpConfiguration> httpConfigurer) {
            this.http = httpConfigurer;
            return this;
        }

        public Builder logging(ComponentConfigurer<LoggingConfiguration> loggingConfigurer) {
            this.logging = loggingConfigurer;
            return this;
        }

        public Builder offline(boolean offline) {
            this.offline = offline;
            return this;
        }

        public Builder serviceEndpoints(ServiceEndpointsBuilder serviceEndpointsBuilder) {
            this.serviceEndpointsBuilder = serviceEndpointsBuilder;
            return this;
        }

        public Builder startWait(Duration startWait) {
            this.startWait = startWait == null ? DEFAULT_START_WAIT : startWait;
            return this;
        }

        public Builder threadPriority(int threadPriority) {
            this.threadPriority = Math.max(1, Math.min(10, threadPriority));
            return this;
        }

        public Builder wrapper(WrapperInfoBuilder wrapperBuilder) {
            this.wrapperBuilder = wrapperBuilder;
            return this;
        }

        public LDConfig build() {
            return new LDConfig(this);
        }
    }
}

