/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.analyzer;

import com.lazerycode.jmeter.analyzer.config.Environment;
import com.lazerycode.jmeter.analyzer.parser.AggregatedResponses;
import com.lazerycode.jmeter.analyzer.parser.JMeterResultParser;
import com.lazerycode.jmeter.analyzer.util.FileUtil;
import com.lazerycode.jmeter.analyzer.writer.Writer;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Properties;
import org.xml.sax.SAXException;

public class ResultAnalyzer {
    private static final String FILENAME_DEFAULT = "summary";
    private String fileName;
    private final String resultDataFileRelativePath;

    public ResultAnalyzer(String resultDataFileRelativePath, String fileName) {
        this.fileName = fileName != null ? fileName : FILENAME_DEFAULT;
        this.resultDataFileRelativePath = resultDataFileRelativePath;
    }

    public Map<String, AggregatedResponses> analyze(Reader jmeterResult) throws IOException, TemplateException, SAXException {
        Map<String, AggregatedResponses> testResults = new JMeterResultParser().aggregate(jmeterResult);
        for (Writer writer : Environment.ENVIRONMENT.getWriters()) {
            writer.setFileName(this.fileName);
            writer.setResultDataFileRelativePath(this.resultDataFileRelativePath);
            writer.write(testResults);
        }
        Properties remoteResources = Environment.ENVIRONMENT.getRemoteResources();
        if (remoteResources != null) {
            FileUtil.readResources(remoteResources, Environment.ENVIRONMENT.getTargetDirectory(), this.resultDataFileRelativePath, testResults.values(), Environment.ENVIRONMENT.getRemoteResourcesFromUntilDateFormat());
        }
        return testResults;
    }
}

