/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.analyzer.parser;

import com.lazerycode.jmeter.analyzer.RequestGroup;
import com.lazerycode.jmeter.analyzer.config.Environment;
import com.lazerycode.jmeter.analyzer.parser.AggregatedResponses;
import com.lazerycode.jmeter.analyzer.parser.StatusCodes;
import com.lazerycode.jmeter.analyzer.statistics.Samples;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.maven.plugin.logging.Log;
import org.springframework.util.AntPathMatcher;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JMeterResultParser {
    private static final int LOGMESSAGE_ITEMS = 10000;

    public Map<String, AggregatedResponses> aggregate(Reader reader) throws IOException, SAXException {
        SAXParser saxParser;
        try {
            saxParser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Parser could not be created ", e);
        }
        Parser parser = new Parser();
        saxParser.parse(new InputSource(reader), (DefaultHandler)parser);
        return parser.getResults();
    }

    private static Log getLog() {
        return Environment.ENVIRONMENT.getLog();
    }

    private static class Parser
    extends DefaultHandler {
        private final AntPathMatcher matcher = new AntPathMatcher();
        private final int maxSamples;
        private final List<RequestGroup> pathPatterns;
        private final boolean sizeByUris;
        private final boolean durationByUris;
        private long parsedCount = 0L;
        private Map<String, AggregatedResponses> results = new LinkedHashMap<String, AggregatedResponses>();
        private Set<String> nodeNames;

        public Parser() {
            this(Environment.ENVIRONMENT.getMaxSamples(), Environment.ENVIRONMENT.getRequestGroups(), Environment.ENVIRONMENT.isGenerateDetails(), Environment.ENVIRONMENT.isGenerateDetails(), Environment.ENVIRONMENT.getSampleNames());
        }

        public Parser(int maxSamples, List<RequestGroup> pathPatterns, boolean sizeByUris, boolean durationByUris, Set<String> nodeNames) {
            this.maxSamples = maxSamples;
            this.pathPatterns = pathPatterns;
            this.sizeByUris = sizeByUris;
            this.durationByUris = durationByUris;
            this.nodeNames = nodeNames;
        }

        public Map<String, AggregatedResponses> getResults() {
            return this.results;
        }

        @Override
        public void startElement(String u, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.nodeNames.contains(localName) || this.nodeNames.contains(qName)) {
                String uri = attributes.getValue("lb");
                String timestampString = attributes.getValue("ts");
                long timestamp = Long.parseLong(timestampString);
                boolean success = Boolean.valueOf(attributes.getValue("s"));
                String key = this.getKey(attributes);
                AggregatedResponses resultContainer = this.getResult(key);
                long bytes = this.parseLong(attributes, "by");
                long duration = this.parseLong(attributes, "t");
                long activeThreads = this.parseLong(attributes, "na");
                int responseCode = this.getResponseCode(attributes);
                this.addData(resultContainer, uri, timestamp, bytes, duration, activeThreads, responseCode, success);
                ++this.parsedCount;
                if (this.parsedCount % 10000L == 0L) {
                    JMeterResultParser.getLog().info((CharSequence)("Parsed " + this.parsedCount + " entries ..."));
                }
            }
            super.startElement(u, localName, qName, attributes);
        }

        @Override
        public void endDocument() throws SAXException {
            super.endDocument();
            for (AggregatedResponses responses : this.results.values()) {
                responses.finish();
            }
            JMeterResultParser.getLog().info((CharSequence)("Finished Parsing " + this.parsedCount + " entries."));
        }

        private void addData(AggregatedResponses resultContainer, String uri, long timestamp, long bytes, long duration, long activeThreads, int responseCode, boolean success) {
            StatusCodes statusCodes = resultContainer.getStatusCodes();
            statusCodes.increment(responseCode);
            Map<Integer, Set<String>> uriByStatusCodeMapping = resultContainer.getUriByStatusCode();
            this.add(uriByStatusCodeMapping, responseCode, uri);
            Samples activeThreadResult = resultContainer.getActiveThreads();
            activeThreadResult.addSample(timestamp + duration, activeThreads);
            if (!success || bytes == -1L || duration == -1L || responseCode >= 400 || responseCode == 599) {
                Samples requestResult = resultContainer.getDuration();
                requestResult.addError(timestamp);
                Samples bytesResult = resultContainer.getSize();
                bytesResult.addError(timestamp);
            } else {
                Samples bytesResult = resultContainer.getSize();
                bytesResult.addSample(timestamp, bytes);
                Samples requestResult = resultContainer.getDuration();
                requestResult.addSample(timestamp, duration);
                Map<String, Samples> sizeByUriMapping = resultContainer.getSizeByUri();
                Map<String, Samples> durationByUriMapping = resultContainer.getDurationByUri();
                this.add(sizeByUriMapping, uri, timestamp, bytes);
                this.add(durationByUriMapping, uri, timestamp, duration);
            }
            if (resultContainer.getStart() == 0L) {
                resultContainer.setStart(timestamp);
            }
            resultContainer.setEnd(timestamp);
        }

        private AggregatedResponses getResult(String key) {
            AggregatedResponses resultContainer = this.results.get(key);
            if (resultContainer == null) {
                resultContainer = new AggregatedResponses();
                resultContainer.setActiveThreads(new Samples(this.maxSamples, true));
                resultContainer.setDuration(new Samples(this.maxSamples, true));
                resultContainer.setSize(new Samples(this.maxSamples, false));
                resultContainer.setStatusCodes(new StatusCodes());
                resultContainer.setUriByStatusCode(new HashMap<Integer, Set<String>>());
                if (this.sizeByUris) {
                    resultContainer.setSizeByUri(new HashMap<String, Samples>());
                }
                if (this.durationByUris) {
                    resultContainer.setDurationByUri(new HashMap<String, Samples>());
                }
                this.results.put(key, resultContainer);
            }
            return resultContainer;
        }

        private int getResponseCode(Attributes atts) {
            int responseCode;
            String responseCodeString = atts.getValue("rc");
            try {
                responseCode = Integer.valueOf(responseCodeString);
            }
            catch (Exception e) {
                JMeterResultParser.getLog().warn((CharSequence)("Error parsing response code '" + responseCodeString + "'"));
                responseCode = 599;
            }
            return responseCode;
        }

        private String getKey(Attributes attributes) {
            String key = null;
            if (this.pathPatterns != null && !this.pathPatterns.isEmpty()) {
                String uri = attributes.getValue("lb");
                for (RequestGroup requestGroup : this.pathPatterns) {
                    if (!this.matcher.match(requestGroup.getPattern(), uri)) continue;
                    key = requestGroup.getName();
                    break;
                }
                if (key == null) {
                    key = "default";
                }
            } else {
                key = attributes.getValue("tn");
                int threadGroupSeparator = key.indexOf(32);
                if (threadGroupSeparator > -1) {
                    key = key.substring(0, threadGroupSeparator);
                }
            }
            return key;
        }

        private void add(Map<String, Samples> uriSamples, String uri, long timestamp, long value) {
            if (uriSamples != null) {
                Samples samples = uriSamples.get(uri);
                if (samples == null) {
                    samples = new Samples(0, false);
                    uriSamples.put(uri, samples);
                }
                samples.addSample(timestamp, value);
            }
        }

        private void add(Map<Integer, Set<String>> uriByStatusCode, Integer code, String uri) {
            if (uriByStatusCode != null) {
                Set<String> uriSet = uriByStatusCode.get(code);
                if (uriSet == null) {
                    uriSet = new HashSet<String>();
                    uriByStatusCode.put(code, uriSet);
                }
                uriSet.add(uri);
            }
        }

        private long parseLong(Attributes attributes, String qName) {
            long result = -1L;
            String valueString = attributes.getValue(qName);
            if (null != valueString) {
                try {
                    result = Long.parseLong(valueString);
                }
                catch (Exception e) {
                    JMeterResultParser.getLog().warn((CharSequence)("Error parsing bytes: '" + valueString + "'"));
                }
            }
            return result;
        }
    }
}

