/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.analyzer.writer;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;

public final class ChartUtil {
    private static final String DATE_FORMAT = "HH:mm:ss";

    private ChartUtil() {
    }

    public static XYPlot createResponseTimesPlot(String domainAxisName) {
        XYPlot plot = ChartUtil.createPlot((ValueAxis)ChartUtil.createNumberAxis(domainAxisName), new ValueAxis[]{ChartUtil.createPercentileAxis("Percentiles (%)"), ChartUtil.createNumberAxis("Count")});
        plot.setOrientation(PlotOrientation.HORIZONTAL);
        return plot;
    }

    public static XYPlot createDatePlot(String rangeAxisName) {
        return ChartUtil.createPlot(ChartUtil.createDateAxis(), new ValueAxis[]{ChartUtil.createNumberAxis(rangeAxisName)});
    }

    public static CombinedDomainXYPlot createCombinedDomainDatePlot() {
        return ChartUtil.createCombinedDomainPlot(ChartUtil.createDateAxis());
    }

    private static CombinedDomainXYPlot createCombinedDomainPlot(ValueAxis domainAxis) {
        CombinedDomainXYPlot combineddomainxyplot = new CombinedDomainXYPlot(domainAxis);
        combineddomainxyplot.setGap(10.0);
        combineddomainxyplot.setOrientation(PlotOrientation.VERTICAL);
        return ChartUtil.defaultPlot(combineddomainxyplot);
    }

    private static XYPlot createPlot(ValueAxis domainAxis, ValueAxis ... rangesAxis) {
        XYPlot plot = new XYPlot();
        plot.setDomainAxis(domainAxis);
        int i = 0;
        for (ValueAxis rangeAxis : rangesAxis) {
            plot.setRangeAxis(i++, rangeAxis);
        }
        return ChartUtil.defaultPlot(plot);
    }

    private static <T extends XYPlot> T defaultPlot(T plot) {
        plot.setOutlineVisible(false);
        plot.setInsets(new RectangleInsets(5.0, 5.0, 5.0, 30.0));
        plot.setBackgroundAlpha(0.0f);
        return plot;
    }

    private static ValueAxis createDateAxis() {
        DateAxis timeAxis = new DateAxis("Timestamp (HH:mm:ss)");
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        timeAxis.setDateFormatOverride((DateFormat)sdf);
        timeAxis.setLowerMargin(0.0);
        timeAxis.setUpperMargin(0.0);
        timeAxis.setAutoRange(true);
        timeAxis.setStandardTickUnits(DateAxis.createStandardDateTickUnits());
        return ChartUtil.defaultAxis(timeAxis);
    }

    private static ValueAxis createPercentileAxis(String axisName) {
        NumberAxis valueAxis = ChartUtil.createNumberAxis(axisName);
        valueAxis.setRange(0.0, 100.1);
        return valueAxis;
    }

    private static NumberAxis createNumberAxis(String axisName) {
        NumberAxis numberAxis = new NumberAxis(axisName);
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return ChartUtil.defaultAxis(numberAxis);
    }

    private static <T extends ValueAxis> T defaultAxis(T axis) {
        axis.setLabelFont(new Font("SansSerif", 2, 12));
        return axis;
    }

    public static XYLineAndShapeRenderer createLineAndShapeRenderer() {
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(true, false);
        return renderer;
    }

    public static XYLineAndShapeRenderer createSecondaryLineAndShapeRenderer() {
        XYLineAndShapeRenderer renderer = ChartUtil.createLineAndShapeRenderer();
        renderer.setSeriesPaint(0, (Paint)Color.GRAY);
        return renderer;
    }

    public static XYBarRenderer createBarRenderer() {
        XYBarRenderer renderer = new XYBarRenderer();
        renderer.setShadowVisible(false);
        return renderer;
    }

    public static XYPlot addDatasetRender(XYPlot plot, XYDataset dataset, XYItemRenderer renderer) {
        int index = plot.getDatasetCount();
        if (index == 1 && plot.getDataset(0) == null) {
            --index;
        }
        plot.setDataset(index, dataset);
        plot.setRenderer(index, renderer);
        return plot;
    }

    public static JFreeChart createJFreeChart(String title, XYPlot result, int imageHeight) {
        JFreeChart chart = new JFreeChart(title, (Plot)result);
        chart.getLegend().setPosition(RectangleEdge.TOP);
        chart.getLegend().setHorizontalAlignment(HorizontalAlignment.LEFT);
        chart.getLegend().setFrame((BlockFrame)BlockBorder.NONE);
        chart.setBackgroundPaint((Paint)new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, imageHeight, new Color(229, 236, 246)));
        chart.getTitle().setFont(new Font("SansSerif", 1, 16));
        chart.getTitle().setPaint((Paint)Color.GRAY);
        return chart;
    }
}

