/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.analyzer.writer;

import com.google.common.annotations.VisibleForTesting;
import com.lazerycode.jmeter.analyzer.config.Environment;
import com.lazerycode.jmeter.analyzer.util.FileUtil;
import com.lazerycode.jmeter.analyzer.util.TemplateUtil;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.io.Resource;

public class HtmlIndexWriter {
    private static final String ROOT_TEMPLATE = "html/index.ftl";
    private String fileName = "index.html";

    public void write(Resource[] resultDataFiles) throws IOException, TemplateException {
        ArrayList<String> tests = new ArrayList<String>(resultDataFiles.length);
        for (Resource resource : resultDataFiles) {
            if (resource.getFilename().isEmpty() || resource.getFilename().lastIndexOf(46) <= -1) continue;
            tests.add(resource.getFilename().substring(0, resource.getFilename().lastIndexOf(46)));
        }
        HashMap<String, ArrayList<String>> self = new HashMap<String, ArrayList<String>>();
        self.put("tests", tests);
        Writer out = this.getWriter(this.getFile(this.fileName));
        this.renderText(self, this.getRootTemplate(), out);
        out.flush();
        out.close();
    }

    protected File getFile(String name) throws IOException {
        return FileUtil.initializeFile(Environment.ENVIRONMENT.getTargetDirectory(), name, null);
    }

    protected String getRootTemplate() {
        return ROOT_TEMPLATE;
    }

    @VisibleForTesting
    protected Writer getWriter(File file) throws IOException {
        return new FileWriter(file);
    }

    protected void renderText(Map<String, ?> self, String rootTemplate, Writer out) throws IOException, TemplateException {
        Map<String, Object> rootMap = TemplateUtil.getRootMap(self);
        rootMap.put("SUMMARY_FILE_NAME", this.fileName);
        Template root = TemplateUtil.getTemplate(rootTemplate);
        root.process(rootMap, out);
    }
}

