/*
 * Decompiled with CFR 0.152.
 */
package com.lewisd.maven.lint;

import com.lewisd.maven.lint.ResultCollector;
import com.lewisd.maven.lint.Rule;
import com.lewisd.maven.lint.Violation;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.model.InputLocation;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class ResultCollectorImpl
implements ResultCollector {
    private final Log log;
    private final List<Violation> violations = new LinkedList<Violation>();

    public ResultCollectorImpl(Log log) {
        this.log = log;
    }

    @Override
    public void writeSummary() {
        if (this.hasViolations()) {
            this.log.info((CharSequence)("[LINT] Completed with " + this.violations.size() + " violations"));
            for (Violation violation : this.violations) {
                this.log.info((CharSequence)("[LINT] " + violation));
            }
        } else {
            this.log.info((CharSequence)"[LINT] Completed with no violations");
        }
    }

    @Override
    public void addViolation(MavenProject mavenProject, Rule rule, String message, InputLocation inputLocation) {
        this.violations.add(new Violation(mavenProject, rule, message, inputLocation));
    }

    @Override
    public boolean hasViolations() {
        return !this.violations.isEmpty();
    }
}

