/*
 * Decompiled with CFR 0.152.
 */
package com.lewisd.maven.lint;

import com.lewisd.maven.lint.ModelBuilder;
import com.lewisd.maven.lint.RuleModelProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.maven.project.MavenProject;

public class RuleModelProviderImpl
implements RuleModelProvider {
    private final HashMap<String, Object> models = new HashMap();
    private final HashMap<String, ModelBuilder> modelBuilders = new HashMap();

    public RuleModelProviderImpl(MavenProject mavenProject) {
        this.models.put("mavenProject", mavenProject);
    }

    @Override
    public Map<String, Object> getModels(Set<String> requiredModels) {
        HashMap<String, Object> ruleModels = new HashMap<String, Object>();
        for (String modelId : requiredModels) {
            Object model = this.models.get(modelId);
            if (model == null) {
                ModelBuilder modelBuilder = this.modelBuilders.get(modelId);
                if (modelBuilder == null) {
                    throw new IllegalArgumentException("No modelBuilder known for modelId '" + modelId + "'");
                }
                Map<String, Object> dependentModels = this.getModels(modelBuilder.getRequiredModels());
                model = modelBuilder.buildModel(dependentModels);
                this.models.put(modelId, model);
            }
            ruleModels.put(modelId, model);
        }
        return ruleModels;
    }

    @Override
    public void addModelBuilder(ModelBuilder modelBuilder) {
        this.modelBuilders.put(modelBuilder.getModelId(), modelBuilder);
    }
}

