/*
 * Decompiled with CFR 0.152.
 */
package com.lewisd.maven.lint.model;

import com.lewisd.maven.lint.ModelBuilder;
import com.lewisd.maven.lint.model.VersionProperty;
import com.lewisd.maven.lint.util.ModelUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.maven.project.MavenProject;
import org.springframework.beans.factory.annotation.Autowired;

public class VersionPropertiesModelBuilder
implements ModelBuilder {
    private static final String MAVEN_PROJECT = "mavenProject";
    private final ModelUtil modelUtil;

    @Autowired
    public VersionPropertiesModelBuilder(ModelUtil modelUtil) {
        this.modelUtil = modelUtil;
    }

    @Override
    public Set<String> getRequiredModels() {
        return Collections.singleton(MAVEN_PROJECT);
    }

    @Override
    public Object buildModel(Map<String, Object> models) {
        HashMap<Object, VersionProperty> versionPropertyByObject = new HashMap<Object, VersionProperty>();
        MavenProject mavenProject = (MavenProject)models.get(MAVEN_PROJECT);
        Collection<Object> objectsToCheck = this.modelUtil.findGAVObjects(mavenProject);
        for (Object object : objectsToCheck) {
            String version = this.modelUtil.getVersion(object);
            if (version == null || !version.contains("${")) continue;
            versionPropertyByObject.put(object, new VersionProperty(version));
        }
        return versionPropertyByObject;
    }

    @Override
    public String getModelId() {
        return "versionProperties";
    }
}

