/*
 * Decompiled with CFR 0.152.
 */
package com.lewisd.maven.lint.plugin;

import com.lewisd.maven.lint.ModelBuilder;
import com.lewisd.maven.lint.ResultCollectorImpl;
import com.lewisd.maven.lint.Rule;
import com.lewisd.maven.lint.RuleInvoker;
import com.lewisd.maven.lint.RuleModelProviderImpl;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class CheckMojo
extends AbstractMojo {
    private MavenProject project;
    private String configLocation;
    private GenericApplicationContext applicationContext;
    private Collection<ModelBuilder> modelBuilders;
    private URLClassLoader classLoader;

    private void initializeConfig() throws DependencyResolutionRequiredException, IOException {
        List testClasspathElements = this.project.getTestClasspathElements();
        URL[] testUrls = new URL[testClasspathElements.size()];
        for (int i = 0; i < testClasspathElements.size(); ++i) {
            String element = (String)testClasspathElements.get(i);
            testUrls[i] = new File(element).toURI().toURL();
        }
        this.classLoader = new URLClassLoader(testUrls, Thread.currentThread().getContextClassLoader());
        this.applicationContext = new GenericApplicationContext();
        ClassPathResource classPathResource = new ClassPathResource(this.configLocation, (ClassLoader)this.classLoader);
        XmlBeanDefinitionReader xmlBeanDefinitionReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)this.applicationContext);
        xmlBeanDefinitionReader.loadBeanDefinitions((Resource)classPathResource);
        this.applicationContext.refresh();
        Map modelBuildersByBeanName = this.applicationContext.getBeansOfType(ModelBuilder.class);
        this.modelBuilders = modelBuildersByBeanName.values();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        ResultCollectorImpl resultCollector = new ResultCollectorImpl(this.getLog());
        try {
            this.initializeConfig();
            RuleModelProviderImpl modelProvider = new RuleModelProviderImpl(this.project);
            RuleInvoker ruleInvoker = new RuleInvoker(this.project, modelProvider);
            Collection<Rule> rules = this.getRules();
            for (ModelBuilder modelBuilder : this.modelBuilders) {
                modelProvider.addModelBuilder(modelBuilder);
            }
            for (Rule rule : rules) {
                ruleInvoker.invokeRule(rule, resultCollector);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while performing check", e);
        }
        finally {
            resultCollector.writeSummary();
        }
        if (resultCollector.hasViolations()) {
            throw new MojoFailureException("[LINT] Violations found.");
        }
    }

    private Collection<Rule> getRules() {
        Map rules = this.applicationContext.getBeansOfType(Rule.class);
        return rules.values();
    }
}

