/*
 * Decompiled with CFR 0.152.
 */
package com.lewisd.maven.lint.plugin;

import com.lewisd.maven.lint.plugin.ModelConvertor;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.plugin.internal.DefaultLegacySupport;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.project.DefaultMavenProjectBuilder;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuilderConfiguration;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.properties.internal.EnvironmentUtils;

public class ModelConvertorImpl
implements ModelConvertor {
    private final LegacySupport legacySupport = new DefaultLegacySupport();
    private final MavenProjectBuilder mavenProjectBuilder = new DefaultMavenProjectBuilder();

    @Override
    public MavenProject convertProject(MavenProject oldProject) {
        try {
            Field projectBuilderConfigurationField = oldProject.getClass().getDeclaredField("projectBuilderConfiguration");
            projectBuilderConfigurationField.setAccessible(true);
            Object object = projectBuilderConfigurationField.get(oldProject);
            if (object instanceof ProjectBuilderConfiguration) {
                System.err.println("Reparsing model for maven2");
                ProjectBuilderConfiguration projectBuilderConfiguration = (ProjectBuilderConfiguration)object;
                ProjectBuildingRequest projectBuildingRequest = this.injectSession(this.toRequest(projectBuilderConfiguration));
            } else {
                System.err.println("Not reparsing, on maven3");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return oldProject;
    }

    private ProjectBuildingRequest toRequest(ProjectBuilderConfiguration configuration) {
        DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest();
        request.setValidationLevel(20);
        request.setResolveDependencies(false);
        request.setLocalRepository(configuration.getLocalRepository());
        request.setBuildStartTime(configuration.getBuildStartTime());
        request.setUserProperties(configuration.getUserProperties());
        request.setSystemProperties(configuration.getExecutionProperties());
        ProfileManager profileManager = configuration.getGlobalProfileManager();
        if (profileManager != null) {
            request.setActiveProfileIds(profileManager.getExplicitlyActivatedIds());
            request.setInactiveProfileIds(profileManager.getExplicitlyDeactivatedIds());
        } else {
            MavenExecutionRequest req;
            MavenSession session = this.legacySupport.getSession();
            if (session != null && (req = session.getRequest()) != null) {
                request.setActiveProfileIds(req.getActiveProfiles());
                request.setInactiveProfileIds(req.getInactiveProfiles());
            }
        }
        return request;
    }

    private ProjectBuildingRequest injectSession(ProjectBuildingRequest request) {
        MavenSession session = this.legacySupport.getSession();
        if (session != null) {
            MavenExecutionRequest req;
            request.setRepositorySession(session.getRepositorySession());
            request.setSystemProperties(session.getSystemProperties());
            if (request.getUserProperties().isEmpty()) {
                request.setUserProperties(session.getUserProperties());
            }
            if ((req = session.getRequest()) != null) {
                request.setRemoteRepositories(req.getRemoteRepositories());
            }
        } else {
            Properties props = new Properties();
            EnvironmentUtils.addEnvVars((Properties)props);
            props.putAll((Map<?, ?>)System.getProperties());
            request.setSystemProperties(props);
        }
        return request;
    }
}

