/*
 * Decompiled with CFR 0.152.
 */
package com.lewisd.maven.lint.rules.basic;

import com.lewisd.maven.lint.ResultCollector;
import com.lewisd.maven.lint.rules.AbstractRule;
import com.lewisd.maven.lint.util.ExpressionEvaluator;
import com.lewisd.maven.lint.util.ModelUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.model.InputLocation;
import org.apache.maven.project.MavenProject;
import org.springframework.beans.factory.annotation.Autowired;

public class GroupArtifactVersionMustBeInCorrectOrderRule
extends AbstractRule {
    private static final List<Object> sortOrder = new LinkedList<Object>();

    @Autowired
    public GroupArtifactVersionMustBeInCorrectOrderRule(ExpressionEvaluator expressionEvaluator, ModelUtil modelUtil) {
        super(expressionEvaluator, modelUtil);
    }

    @Override
    protected void addRequiredModels(Set<String> requiredModels) {
    }

    @Override
    public String getIdentifier() {
        return "GAVORDER";
    }

    @Override
    public void invoke(MavenProject mavenProject, Map<String, Object> models, ResultCollector resultCollector) {
        Collection<Object> objectsToCheck = this.modelUtil.findGAVObjects(mavenProject);
        block0: for (Object object : objectsToCheck) {
            Map<Object, InputLocation> locations = this.modelUtil.getLocations(object);
            TreeMap<InputLocation, Object> actualOrderedElements = new TreeMap<InputLocation, Object>(new InputLocationMapValueComparator());
            for (Map.Entry<Object, InputLocation> entry : locations.entrySet()) {
                actualOrderedElements.put(entry.getValue(), entry.getKey());
            }
            LinkedList<Object> expectedOrderElements = new LinkedList<Object>();
            for (Object location : sortOrder) {
                if (!locations.containsKey(location)) continue;
                expectedOrderElements.add(location);
            }
            for (Object location : actualOrderedElements.values()) {
                if (expectedOrderElements.contains(location)) continue;
                expectedOrderElements.add(location);
            }
            expectedOrderElements.retainAll(locations.keySet());
            Iterator expectedOrderElementIterator = expectedOrderElements.iterator();
            Iterator actualOrderedElementsIterator = actualOrderedElements.values().iterator();
            while (expectedOrderElementIterator.hasNext() && actualOrderedElementsIterator.hasNext()) {
                Object actualElement;
                Object expectedElement = expectedOrderElementIterator.next();
                if (expectedElement.equals(actualElement = actualOrderedElementsIterator.next())) continue;
                resultCollector.addViolation(mavenProject, this, "Found '" + actualElement + "' but was expecting '" + expectedElement + "'", locations.get(actualElement));
                continue block0;
            }
        }
    }

    static {
        sortOrder.add("");
        sortOrder.add("modelVersion");
        sortOrder.add("extensions");
        sortOrder.add("groupId");
        sortOrder.add("artifactId");
        sortOrder.add("classifier");
        sortOrder.add("type");
        sortOrder.add("version");
        sortOrder.add("scope");
    }

    private class InputLocationMapValueComparator
    implements Comparator<InputLocation> {
        private InputLocationMapValueComparator() {
        }

        @Override
        public int compare(InputLocation a, InputLocation b) {
            if (a.getLineNumber() == b.getLineNumber()) {
                return a.getColumnNumber() - b.getColumnNumber();
            }
            return a.getLineNumber() - b.getLineNumber();
        }
    }
}

