/*
 * Decompiled with CFR 0.152.
 */
package com.lewisd.maven.lint.rules.basic;

import com.lewisd.maven.lint.ResultCollector;
import com.lewisd.maven.lint.model.VersionProperty;
import com.lewisd.maven.lint.rules.AbstractRule;
import com.lewisd.maven.lint.util.ExpressionEvaluator;
import com.lewisd.maven.lint.util.ModelUtil;
import java.util.Map;
import java.util.Set;
import org.apache.maven.model.InputLocation;
import org.apache.maven.project.MavenProject;
import org.springframework.beans.factory.annotation.Autowired;

public class VersionPropertiesMustNotUseHyphenRule
extends AbstractRule {
    @Autowired
    public VersionPropertiesMustNotUseHyphenRule(ExpressionEvaluator expressionEvaluator, ModelUtil modelUtil) {
        super(expressionEvaluator, modelUtil);
    }

    @Override
    protected void addRequiredModels(Set<String> requiredModels) {
        requiredModels.add("versionProperties");
    }

    @Override
    public String getIdentifier() {
        return "VERSIONPROPHYPHEN";
    }

    @Override
    public void invoke(MavenProject mavenProject, Map<String, Object> models, ResultCollector resultCollector) {
        Map versionPropertyByObject = (Map)models.get("versionProperties");
        for (Map.Entry entry : versionPropertyByObject.entrySet()) {
            VersionProperty versionProperty = (VersionProperty)entry.getValue();
            for (String propertyName : versionProperty.getPropertyNames()) {
                if (!propertyName.contains("-")) continue;
                InputLocation location = this.modelUtil.getLocation(entry.getKey(), "version");
                resultCollector.addViolation(mavenProject, this, "Version property names must not contain a hyphen: '" + propertyName + "'", location);
            }
        }
    }
}

