/*
 * Decompiled with CFR 0.152.
 */
package com.lewisd.maven.lint.util;

import com.lewisd.maven.lint.util.ReflectionUtil;
import java.util.Collection;
import java.util.LinkedList;
import org.springframework.beans.factory.annotation.Autowired;

public class ExpressionEvaluator {
    private final ReflectionUtil reflectionUtil;

    @Autowired
    public ExpressionEvaluator(ReflectionUtil reflectionUtil) {
        this.reflectionUtil = reflectionUtil;
    }

    public Collection<Object> getPath(Object root, String path) {
        LinkedList<Object> objects = new LinkedList<Object>();
        this.getPath(root, path, objects);
        return objects;
    }

    private void getPath(Object root, String path, Collection<Object> objects) {
        String[] pathParts = path.split("/", 2);
        String element = pathParts[0];
        char firstCharacter = Character.toUpperCase(element.charAt(0));
        String methodName = "get" + Character.toString(firstCharacter) + element.substring(1);
        Object returned = this.reflectionUtil.callMethod(root, methodName, new Class[0], new Object[0]);
        if (returned != null) {
            if (returned instanceof Collection) {
                if (pathParts.length > 1) {
                    for (Object object : (Collection)returned) {
                        this.getPath(object, pathParts[1], objects);
                    }
                } else {
                    objects.addAll((Collection)returned);
                }
            } else if (pathParts.length > 1) {
                this.getPath(returned, pathParts[1], objects);
            } else {
                objects.add(returned);
            }
        }
    }
}

