/*
 * Decompiled with CFR 0.152.
 */
package com.lewisd.maven.lint.util;

import com.lewisd.maven.lint.util.ExpressionEvaluator;
import com.lewisd.maven.lint.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.springframework.beans.factory.annotation.Autowired;

public class ModelUtil {
    private final ReflectionUtil reflectionUtil;
    private final ExpressionEvaluator expressionEvaluator;

    @Autowired
    public ModelUtil(ReflectionUtil reflectionUtil, ExpressionEvaluator expressionEvaluator) {
        this.reflectionUtil = reflectionUtil;
        this.expressionEvaluator = expressionEvaluator;
    }

    public InputLocation getLocation(Object modelObject, Object key) {
        String methodName = "getLocation";
        return (InputLocation)this.reflectionUtil.callMethod(modelObject, methodName, new Class[]{Object.class}, new Object[]{key});
    }

    public String getVersion(Object modelObject) {
        String methodName = "getVersion";
        return (String)this.reflectionUtil.callMethod(modelObject, methodName, new Class[0], new Object[0]);
    }

    public String getArtifactId(Object modelObject) {
        String methodName = "getArtifactId";
        return (String)this.reflectionUtil.callMethod(modelObject, methodName, new Class[0], new Object[0]);
    }

    public String getGroupId(Object modelObject) {
        String methodName = "getGroupId";
        return (String)this.reflectionUtil.callMethod(modelObject, methodName, new Class[0], new Object[0]);
    }

    public String getType(Object modelObject) {
        String methodName = "getType";
        return (String)this.reflectionUtil.callMethod(modelObject, methodName, new Class[0], new Object[0]);
    }

    public String getClassifier(Object modelObject) {
        String methodName = "getClassifier";
        return (String)this.reflectionUtil.callMethod(modelObject, methodName, new Class[0], new Object[0]);
    }

    public Map<Object, InputLocation> getLocations(Object modelObject) {
        Dependency dependency;
        List exclusions;
        Class<?> klass = modelObject.getClass();
        Map<Object, InputLocation> locations = this.getLocations(modelObject, klass);
        if (modelObject instanceof Plugin) {
            Plugin plugin = (Plugin)modelObject;
            List executions = plugin.getExecutions();
            if (executions != null && !executions.isEmpty()) {
                PluginExecution pluginExecution = (PluginExecution)executions.get(0);
                locations.put("execution", pluginExecution.getLocation((Object)""));
            }
        } else if (modelObject instanceof Dependency && (exclusions = (dependency = (Dependency)modelObject).getExclusions()) != null && !exclusions.isEmpty()) {
            Exclusion exclusion = (Exclusion)exclusions.get(0);
            locations.put("exclusion", exclusion.getLocation((Object)""));
        }
        return locations;
    }

    public Collection<Object> findGAVObjects(MavenProject mavenProject) {
        LinkedList<Object> objects = new LinkedList<Object>();
        Model originalModel = mavenProject.getOriginalModel();
        objects.add(originalModel);
        objects.addAll(this.expressionEvaluator.getPath(originalModel, "dependencies"));
        objects.addAll(this.expressionEvaluator.getPath(originalModel, "dependencyManagement/dependencies"));
        objects.addAll(this.expressionEvaluator.getPath(originalModel, "build/plugins"));
        objects.addAll(this.expressionEvaluator.getPath(originalModel, "build/plugins/dependencies"));
        objects.addAll(this.expressionEvaluator.getPath(originalModel, "build/pluginManagement/plugins"));
        objects.addAll(this.expressionEvaluator.getPath(originalModel, "build/pluginManagement/plugins/dependencies"));
        return objects;
    }

    private Map<Object, InputLocation> getLocations(Object modelObject, Class klass) {
        try {
            Field field = klass.getDeclaredField("locations");
            field.setAccessible(true);
            HashMap<Object, InputLocation> locations = new HashMap<Object, InputLocation>();
            locations.putAll((Map)field.get(modelObject));
            return locations;
        }
        catch (NoSuchFieldException e) {
            if (klass.getSuperclass() == null) {
                throw new IllegalArgumentException("No 'locations' field found on object of type " + klass, e);
            }
            return this.getLocations(modelObject, klass.getSuperclass());
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("Failed to get 'locations' field on object of type " + klass, e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Failed to get 'locations' field on object of type " + klass, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Failed to get 'locations' field on object of type " + klass, e);
        }
    }
}

