/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ant.bnd.service;

import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Jar;
import aQute.bnd.service.AnalyzerPlugin;
import aQute.bnd.version.Version;
import java.util.Map;

public class ServiceAnalyzerPlugin
implements AnalyzerPlugin {
    private static final String _LIFERAY_EXTENDER = "liferay.extender";

    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        boolean liferayService = Boolean.parseBoolean(analyzer.getProperty("Liferay-Service"));
        if (!liferayService) {
            return false;
        }
        Jar portalSpringExtenderJar = this.getClasspathJar(analyzer, "com.liferay.portal.spring.extender");
        if (portalSpringExtenderJar == null) {
            return false;
        }
        this.processRequireCapability(analyzer, portalSpringExtenderJar);
        this.processSpringContext(analyzer);
        this.processSpringDependency(analyzer);
        return false;
    }

    protected Jar getClasspathJar(Analyzer analyzer, String bundleSymbolicName) throws Exception {
        for (Jar jar : analyzer.getClasspath()) {
            if (!bundleSymbolicName.equals(jar.getBsn())) continue;
            return jar;
        }
        return null;
    }

    protected void merge(Analyzer analyzer, String key, String value) {
        Parameters parameters = new Parameters(analyzer.getProperty(key));
        parameters.mergeWith(new Parameters(value), false);
        analyzer.setProperty(key, parameters.toString());
    }

    protected void processRequireCapability(Analyzer analyzer, Jar portalSpringExtenderJar) throws Exception {
        Parameters requireCapabilityHeaders = new Parameters(analyzer.getProperty("Require-Capability"));
        Parameters parameters = new Parameters();
        Attrs attrs = new Attrs();
        Version portalSpringExtenderVersion = Version.parseVersion((String)portalSpringExtenderJar.getVersion());
        StringBuilder sb = new StringBuilder();
        sb.append("(&(");
        sb.append(_LIFERAY_EXTENDER);
        sb.append("=spring.extender)(version>=");
        sb.append(portalSpringExtenderVersion.getMajor());
        sb.append(".0)(!(version>=");
        sb.append(portalSpringExtenderVersion.getMajor() + 1);
        sb.append(".0)))");
        attrs.put("filter:", sb.toString());
        parameters.add(_LIFERAY_EXTENDER, attrs);
        requireCapabilityHeaders.mergeWith(parameters, false);
        analyzer.setProperty("Require-Capability", requireCapabilityHeaders.toString());
    }

    protected void processSpringContext(Analyzer analyzer) {
        Jar jar = analyzer.getJar();
        Map directories = jar.getDirectories();
        if (!directories.containsKey("META-INF/spring")) {
            return;
        }
        this.merge(analyzer, "Liferay-Spring-Context", "META-INF/spring");
    }

    protected void processSpringDependency(Analyzer analyzer) {
        this.merge(analyzer, "-liferay-spring-dependency", "com.liferay.portal.spring.extender.service.ServiceReference");
    }
}

