/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ant.bnd;

import aQute.bnd.differ.Baseline;
import aQute.bnd.differ.DiffPluginImpl;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Resource;
import aQute.bnd.service.diff.Delta;
import aQute.bnd.service.diff.Diff;
import aQute.bnd.service.diff.Differ;
import aQute.bnd.version.Version;
import aQute.lib.io.IO;
import aQute.service.reporter.Reporter;
import com.liferay.ant.bnd.BaselineProcessor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public abstract class Baseline {
    private File _bndFile;
    private boolean _forceCalculatedVersion;
    private boolean _forcePackageInfo;
    private boolean _forceVersionOneOnAddedPackages = true;
    private boolean _headerPrinted;
    private File _logFile;
    private File _newCompatJarFile;
    private File _newJarFile;
    private File _oldJarFile;
    private PrintWriter _printWriter;
    private final Properties _properties = new Properties();
    private boolean _reportDiff;
    private boolean _reportOnlyDirtyPackages;
    private File _sourceDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws Exception {
        boolean match = true;
        this._headerPrinted = false;
        this._printWriter = null;
        if (this._logFile.exists()) {
            this._logFile.delete();
        }
        File logDir = this._logFile.getParentFile();
        logDir.mkdirs();
        BaselineProcessor baselineProcessor = new BaselineProcessor();
        baselineProcessor.setProperties(this._properties);
        Jar newJar = new Jar(this._newJarFile);
        if (this._newCompatJarFile != null) {
            newJar.addAll(new Jar(this._newCompatJarFile));
        }
        Jar oldJar = null;
        if (this._oldJarFile != null) {
            if (!this._oldJarFile.exists() || this._oldJarFile.isDirectory() || !this._oldJarFile.canRead()) {
                baselineProcessor.warning("Baseline file %s is invalid. Check if it exists, is readable, and is not a directory.", new Object[]{this._oldJarFile});
            } else {
                oldJar = new Jar(this._oldJarFile);
            }
        } else {
            oldJar = baselineProcessor.getBaselineJar();
        }
        try {
            if (oldJar == null) {
                boolean bl = match;
                return bl;
            }
            aQute.bnd.differ.Baseline baseline = new aQute.bnd.differ.Baseline((Reporter)baselineProcessor, (Differ)new DiffPluginImpl());
            Set infos = baseline.baseline(newJar, oldJar, null);
            if (infos.isEmpty()) {
                boolean bl = match;
                return bl;
            }
            Baseline.BundleInfo bundleInfo = baseline.getBundleInfo();
            if (this._forceCalculatedVersion) {
                bundleInfo.suggestedVersion = this.calculateVersion(bundleInfo.olderVersion, infos);
            } else if (this.hasPackageRemoved(infos)) {
                bundleInfo.suggestedVersion = new Version(bundleInfo.olderVersion.getMajor() + 1, 0, 0);
            }
            int compare = bundleInfo.suggestedVersion.compareTo(bundleInfo.newerVersion.getWithoutQualifier());
            if (compare > 0 || this._forceCalculatedVersion && compare != 0) {
                bundleInfo.mismatch = true;
            }
            if (bundleInfo.mismatch) {
                match = false;
                this.updateBundleVersion(bundleInfo.newerVersion, bundleInfo.suggestedVersion);
            }
            Baseline.Info[] infosArray = infos.toArray(new Baseline.Info[infos.size()]);
            Arrays.sort(infosArray, new Comparator<Baseline.Info>(){

                @Override
                public int compare(Baseline.Info info1, Baseline.Info info2) {
                    return info1.packageName.compareTo(info2.packageName);
                }
            });
            this.doHeader(bundleInfo);
            for (Baseline.Info info : infosArray) {
                if (info.mismatch) {
                    match = false;
                }
                Diff packageDiff = info.packageDiff;
                Delta delta = packageDiff.getDelta();
                if (this._forceVersionOneOnAddedPackages && delta == Delta.ADDED && bundleInfo.newerVersion.equals((Object)info.newerVersion)) {
                    info.suggestedVersion = Version.ONE;
                }
                String warnings = "-";
                Version newerVersion = info.newerVersion;
                Version suggestedVersion = info.suggestedVersion;
                if (suggestedVersion != null) {
                    if (newerVersion.compareTo(suggestedVersion) > 0) {
                        match = false;
                        warnings = "EXCESSIVE VERSION INCREASE";
                    } else if (newerVersion.compareTo(suggestedVersion) < 0) {
                        warnings = "VERSION INCREASE REQUIRED";
                    }
                }
                if (delta == Delta.REMOVED) {
                    warnings = "PACKAGE REMOVED";
                } else if (delta == Delta.UNCHANGED) {
                    boolean newVersionSuggested = false;
                    if (suggestedVersion.compareTo(newerVersion) > 0) {
                        warnings = "VERSION INCREASE SUGGESTED";
                        newVersionSuggested = true;
                    } else if (suggestedVersion.compareTo(newerVersion) < 0) {
                        warnings = "EXCESSIVE VERSION INCREASE";
                        newVersionSuggested = true;
                    }
                    if (!newVersionSuggested && !info.mismatch) continue;
                }
                boolean correctPackageInfo = this.generatePackageInfo(newJar, info, delta);
                if (!correctPackageInfo) {
                    if (delta == Delta.ADDED) {
                        warnings = "PACKAGE ADDED, MISSING PACKAGEINFO";
                    } else if (delta == Delta.REMOVED) {
                        warnings = "PACKAGE REMOVED, UNNECESSARY PACKAGEINFO";
                    }
                }
                if ((!this._reportDiff || this._reportOnlyDirtyPackages) && warnings.equals("-") || this._reportOnlyDirtyPackages && correctPackageInfo && delta == Delta.REMOVED) continue;
                this.doInfo(bundleInfo, info, warnings);
                if (!this._reportDiff || delta == Delta.REMOVED) continue;
                this.doPackageDiff(packageDiff);
            }
        }
        finally {
            this.log((Reporter)baselineProcessor);
            baselineProcessor.close();
            newJar.close();
            if (oldJar != null) {
                oldJar.close();
            }
            if (this._printWriter != null) {
                this._printWriter.close();
            }
        }
        return match;
    }

    public Properties getProperties() {
        return this._properties;
    }

    public void setBndFile(File bndFile) {
        this._bndFile = bndFile;
    }

    public void setForceCalculatedVersion(boolean forceCalculatedVersion) {
        this._forceCalculatedVersion = forceCalculatedVersion;
    }

    public void setForcePackageInfo(boolean forcePackageInfo) {
        this._forcePackageInfo = forcePackageInfo;
    }

    public void setForceVersionOneOnAddedPackages(boolean forceVersionOneOnAddedPackages) {
        this._forceVersionOneOnAddedPackages = forceVersionOneOnAddedPackages;
    }

    public void setLogFile(File logFile) {
        this._logFile = logFile;
    }

    public void setNewCompatJarFile(File newCompatJarFile) {
        this._newCompatJarFile = newCompatJarFile;
    }

    public void setNewJarFile(File newJarFile) {
        this._newJarFile = newJarFile;
    }

    public void setOldJarFile(File oldJarFile) {
        this._oldJarFile = oldJarFile;
    }

    public void setReportDiff(boolean reportDiff) {
        this._reportDiff = reportDiff;
    }

    public void setReportOnlyDirtyPackages(boolean reportOnlyDirtyPackages) {
        this._reportOnlyDirtyPackages = reportOnlyDirtyPackages;
    }

    public void setSourceDir(File sourceDir) {
        this._sourceDir = sourceDir;
    }

    protected Version calculateVersion(Version version, Set<Baseline.Info> infos) throws IOException {
        Delta highestDelta = Delta.UNCHANGED;
        Set<String> movedPackages = this.getMovedPackages();
        for (Baseline.Info info : infos) {
            Delta delta = info.packageDiff.getDelta();
            if (delta == Delta.ADDED || delta == Delta.CHANGED) {
                delta = Delta.MICRO;
            } else if (delta == Delta.REMOVED) {
                delta = movedPackages.contains(info.packageName) ? Delta.MICRO : Delta.MAJOR;
            }
            if (delta.compareTo((Enum)highestDelta) <= 0) continue;
            highestDelta = delta;
        }
        version = highestDelta == Delta.MAJOR ? new Version(version.getMajor() + 1, 0, 0) : (highestDelta == Delta.MINOR ? new Version(version.getMajor(), version.getMinor() + 1, 0) : new Version(version.getMajor(), version.getMinor(), version.getMicro() + 1));
        return version;
    }

    protected void doDiff(Diff diff, StringBuilder sb) {
        String type = String.valueOf(diff.getType());
        String output = String.format("%s%-3s %-10s %s", sb, this.getShortDelta(diff.getDelta()), type.toLowerCase(), diff.getName());
        this.log(output);
        if (this._printWriter != null) {
            this._printWriter.println(output);
        }
        sb.append("\t");
        for (Diff curDiff : diff.getChildren()) {
            if (curDiff.getDelta() == Delta.UNCHANGED) continue;
            this.doDiff(curDiff, sb);
        }
        sb.deleteCharAt(sb.length() - 1);
    }

    protected void doHeader(Baseline.BundleInfo bundleInfo) throws IOException {
        if (!bundleInfo.mismatch) {
            return;
        }
        String output = "[Baseline Report] Mode: ";
        output = this._reportDiff ? output + "diff" : output + "standard";
        if (this._logFile != null) {
            output = output + " (persisted)";
        }
        this.log(output);
        output = "[Baseline Warning] Bundle Version Change Recommended: " + bundleInfo.suggestedVersion;
        this.log(output);
        this.persistLog(output);
    }

    protected void doInfo(Baseline.BundleInfo bundleInfo, Baseline.Info info, String warnings) throws IOException {
        this.doPackagesHeader(bundleInfo);
        this.reportLog(String.valueOf(info.mismatch ? (char)'*' : ' '), info.packageName, String.valueOf(info.packageDiff.getDelta()), String.valueOf(info.newerVersion), String.valueOf(info.olderVersion), String.valueOf(info.suggestedVersion == null ? "-" : info.suggestedVersion), warnings, String.valueOf(info.attributes));
    }

    protected void doPackageDiff(Diff diff) {
        StringBuilder sb = new StringBuilder();
        sb.append("\t");
        for (Diff curDiff : diff.getChildren()) {
            if (curDiff.getDelta() == Delta.UNCHANGED) continue;
            this.doDiff(curDiff, sb);
        }
    }

    protected void doPackagesHeader(Baseline.BundleInfo bundleInfo) throws IOException {
        if (this._headerPrinted) {
            return;
        }
        this._headerPrinted = true;
        this.reportLog(" ", "PACKAGE_NAME", "DELTA", "CUR_VER", "BASE_VER", "REC_VER", "WARNINGS", "ATTRIBUTES");
        this.reportLog("=", "==================================================", "==========", "==========", "==========", "==========", "==========", "==========");
    }

    protected boolean generatePackageInfo(Jar jar, Baseline.Info info, Delta delta) throws Exception {
        boolean correct = true;
        File packageDir = new File(this._sourceDir, info.packageName.replace('.', File.separatorChar));
        if (!this._forcePackageInfo && !packageDir.exists()) {
            return correct;
        }
        File packageInfoFile = new File(packageDir, "packageinfo");
        if (delta == Delta.REMOVED) {
            if (packageInfoFile.exists()) {
                correct = false;
                packageInfoFile.delete();
            }
        } else {
            boolean writePackageInfoFile = true;
            if (!packageInfoFile.exists()) {
                correct = false;
                Resource resource = jar.getResource(info.packageName.replace('.', '/') + "/packageinfo");
                if (resource != null) {
                    Version version;
                    writePackageInfoFile = false;
                    String content = IO.collect((InputStream)resource.openInputStream());
                    if (content.startsWith("version ") && (version = Version.parseVersion((String)content.substring(8))).equals((Object)info.suggestedVersion)) {
                        correct = true;
                    }
                }
            }
            if (writePackageInfoFile) {
                packageDir.mkdirs();
                try (FileOutputStream fileOutputStream = new FileOutputStream(packageInfoFile);){
                    String content = "version " + info.suggestedVersion;
                    fileOutputStream.write(content.getBytes());
                }
            }
        }
        return correct;
    }

    protected Set<String> getMovedPackages() throws IOException {
        File movedPackagesFile = new File(this._bndFile.getParentFile(), "moved-packages.txt");
        if (!movedPackagesFile.exists()) {
            return Collections.emptySet();
        }
        HashSet<String> movedPackages = new HashSet<String>();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(movedPackagesFile));){
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                movedPackages.add(line);
            }
        }
        return movedPackages;
    }

    protected String getShortDelta(Delta delta) {
        if (delta == Delta.ADDED) {
            return "+";
        }
        if (delta == Delta.CHANGED) {
            return "~";
        }
        if (delta == Delta.MAJOR) {
            return ">";
        }
        if (delta == Delta.MICRO) {
            return "0xB5";
        }
        if (delta == Delta.MINOR) {
            return "<";
        }
        if (delta == Delta.REMOVED) {
            return "-";
        }
        String deltaString = delta.toString();
        return String.valueOf(deltaString.charAt(0));
    }

    protected boolean hasPackageRemoved(Iterable<Baseline.Info> infos) throws IOException {
        Set<String> movedPackages = this.getMovedPackages();
        for (Baseline.Info info : infos) {
            if (info.packageDiff.getDelta() != Delta.REMOVED || movedPackages.contains(info.packageName)) continue;
            return true;
        }
        return false;
    }

    protected abstract void log(Reporter var1);

    protected abstract void log(String var1);

    protected void persistLog(String output) throws IOException {
        if (this._logFile == null) {
            return;
        }
        if (this._printWriter == null) {
            this._logFile.createNewFile();
            this._printWriter = new PrintWriter(this._logFile);
        }
        this._printWriter.println(output);
    }

    protected void reportLog(String string1, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws IOException {
        String output = String.format("%s %-50s %-10s %-10s %-10s %-10s %-10s", string1, string2, string3, string4, string5, string6, string7);
        this.log(output);
        this.persistLog(output);
    }

    protected void updateBundleVersion(Version oldVersion, Version newVersion) throws IOException {
        if (this._bndFile == null) {
            return;
        }
        String content = IO.collect((File)this._bndFile);
        content = content.replace("Bundle-Version: " + oldVersion, "Bundle-Version: " + newVersion);
        IO.store((Object)content, (File)this._bndFile);
    }
}

